% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateOverlap.r
\name{calculateOverlap}
\alias{calculateOverlap}
\title{Calculate Bins Overlap}
\usage{
calculateOverlap(
  data,
  db = NULL,
  penalty = NULL,
  virtual = TRUE,
  debug = FALSE
)
}
\arguments{
\item{data}{data frame providing kit information.}

\item{db}{data frame allele frequency database.}

\item{penalty}{vector with factors for reducing the impact from distant dye channels.
NB! Length must equal number of dyes in kit minus one.}

\item{virtual}{logical default is TRUE meaning that overlap calculation includes virtual bins.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame with columns 'Kit', 'Color', [dyes], 'Sum', and 'Score'.
}
\description{
Analyses the bins overlap between colors.
}
\details{
By analyzing the bins overlap between dye channels a measure of
the risk for spectral pull-up artefacts can be obtain. The default result
is a matrix with the total bins overlap in number of base pairs. If an allele
frequency database is provided the overlap at each bin is multiplied with the
frequency of the corresponding allele. If no frequence exist for that allele
a frequency of 5/2N will be used. X and Y alleles is given the frequency 1.
A penalty matrix can be supplied to reduce the effect by spectral distance,
meaning that overlap with the neighboring dye can be counted in full (100%)
while a non neighbor dye get its overlap reduced (to e.g. 10%).
}
