% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styling.R
\name{theme_gt_compact}
\alias{theme_gt_compact}
\title{Apply compact JAMA-style theme to gt tables}
\usage{
theme_gt_compact(tbl)
}
\arguments{
\item{tbl}{A gt table object created with \code{gt::gt()}}
}
\value{
A gt table object with compact JAMA-style formatting applied
}
\description{
Applies a compact table theme to gt tables that matches the
'jama' theme from gtsummary. This ensures visual consistency when mixing
gtsummary tables (using \code{theme_gtsummary_compact("jama")}) with regular
gt tables in the same document. The theme reduces padding, adjusts font
sizes, and applies JAMA journal styling conventions.
}
\details{
This function replicates the visual appearance of
\code{gtsummary::theme_gtsummary_compact("jama")} for use with regular gt tables.
Key styling includes:
\itemize{
\item Reduced font size (13px) for compact appearance
\item Minimal padding (1px) on all row types
\item Bold column headers and table titles
\item Hidden top and bottom table borders
\item Consistent spacing that matches JAMA journal standards
}
}
\examples{
# Basic usage with a data frame
mtcars |>
  head() |>
  gt::gt() |>
  theme_gt_compact()

# Combine with other gt functions
mtcars |>
  head() |>
  gt::gt() |>
  gt::tab_header(title = "Vehicle Data") |>
  theme_gt_compact()

# Use alongside gtsummary tables for consistency
# Set gtsummary theme first
gtsummary::set_gtsummary_theme(gtsummary::theme_gtsummary_compact("jama"))

# Then both tables will have matching appearance
summary_table <- gtsummary::trial |>
  gtsummary::tbl_summary()

data_table <- gtsummary::trial |>
  head() |>
  gt::gt() |>
  theme_gt_compact()

}
\seealso{
\itemize{
\item \code{gtsummary::theme_gtsummary_compact()} for gtsummary table themes
\item \code{gtsummary::set_gtsummary_theme()} for setting global gtsummary themes
\item \code{gt::tab_options()} for additional gt table styling options
}
}
