% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{priors}
\alias{priors}
\alias{p_normal}
\alias{p_t}
\alias{p_beta}
\alias{p_gamma}
\title{Prior distributions and options}
\usage{
p_normal(location = 0, scale = 2.5)

p_t(location = 0, scale = 2.5, df = 1)

p_beta(shape1 = 1, shape2 = 1)

p_gamma(shape = 2, rate = 1)
}
\arguments{
\item{location}{Prior location. For the normal distribution, this is the mean.
Defaults to 0}

\item{scale}{Prior scale.  For the normal distribution, this is the standard deviation.
Defaults to 2.5.}

\item{df}{Prior degrees of freedom (only for Student t distribution).}

\item{shape1}{First shape parameter (for Beta distribution, defaults to 1).}

\item{shape2}{Second shape parameter (for Beta distribution, defaults to 1).}

\item{shape}{Shape parameter (for Gamma distribution, defaults to 2).}

\item{rate}{Rate parameter (for Gamma distribution, defaults to 1).}
}
\value{
A named list with the prior distribution name and parameters, to be used internally by the \code{\link{survextrap}} model fitting functions.
}
\description{
The functions described on this page are used to specify the prior distributions for the parameters in a survextrap model.
}
\seealso{
\code{\link{survextrap}}.
}
