% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsurvplot.R
\name{ggsurvplot}
\alias{ggsurvplot}
\alias{print.ggsurvplot}
\title{Drawing Survival Curves Using ggplot2}
\usage{
ggsurvplot(
  fit,
  data = NULL,
  fun = NULL,
  color = NULL,
  palette = NULL,
  linetype = 1,
  conf.int = FALSE,
  pval = FALSE,
  pval.method = FALSE,
  test.for.trend = FALSE,
  surv.median.line = "none",
  risk.table = FALSE,
  cumevents = FALSE,
  cumcensor = FALSE,
  tables.height = 0.25,
  group.by = NULL,
  facet.by = NULL,
  add.all = FALSE,
  combine = FALSE,
  ggtheme = theme_survminer(),
  tables.theme = ggtheme,
  ...
)

\method{print}{ggsurvplot}(
  x,
  surv.plot.height = NULL,
  risk.table.height = NULL,
  ncensor.plot.height = NULL,
  newpage = TRUE,
  ...
)
}
\arguments{
\item{fit}{allowed values include:
\itemize{
\item a survfit object
\item a list of survfit objects. Passed to \code{\link{ggsurvplot_list}()}
\item a data frame containing survival curves summary. Passed to \code{\link{ggsurvplot_df}()}.
}}

\item{data}{a dataset used to fit survival curves. If not supplied then data
will be extracted from 'fit' object.}

\item{fun}{an arbitrary function defining a transformation of the survival
curve.  Often used transformations can be specified with a character
argument: "event" plots cumulative events (f(y) = 1-y), "cumhaz" plots the
cumulative hazard function (f(y) = -log(y)), and "pct" for survival
probability in percentage.}

\item{color}{color to be used for the survival curves. \itemize{ \item If the
number of strata/group (n.strata) = 1, the expected value is the color name.
For example color = "blue". \item If n.strata > 1, the expected value is the
grouping variable name. By default, survival curves are colored by strata
using the argument color = "strata",  but you can also color survival curves
by any other grouping variables used to fit the survival curves. In this
case, it's possible to specify a custom color palette by using the argument
palette.}}

\item{palette}{the color palette to be used. Allowed values include "hue" for
the default hue color scale; "grey" for grey color palettes; brewer palettes
e.g. "RdBu", "Blues", ...; or custom color palette e.g. c("blue", "red"); and scientific journal palettes from ggsci R package, e.g.: "npg",
 "aaas", "lancet", "jco", "ucscgb", "uchicago", "simpsons" and
 "rickandmorty".
See details section for more information.  Can be also a numeric vector of
length(groups); in this case a basic color palette is created using the
function \link[grDevices]{palette}.}

\item{linetype}{line types. Allowed values includes i) "strata" for changing
linetypes by strata (i.e. groups); ii) a numeric vector (e.g., c(1, 2)) or a
character vector c("solid", "dashed").}

\item{conf.int}{logical value. If TRUE, plots confidence interval.}

\item{pval}{logical value, a numeric or a string. If logical and TRUE, the
p-value is added on the plot. If numeric, than the computet p-value is
substituted with the one passed with this parameter. If character, then the
customized string appears on the plot. See examples - Example 3.}

\item{pval.method}{whether to add a text with the test name used for
calculating the pvalue, that corresponds to survival curves' comparison -
used only when \code{pval=TRUE}}

\item{test.for.trend}{logical value. Default is FALSE. If TRUE, returns the
test for trend p-values. Tests for trend are designed to detect ordered
differences in survival curves. That is, for at least one group. The test
for trend can be only performed when the number of groups is > 2.}

\item{surv.median.line}{character vector for drawing a horizontal/vertical
line at median survival. Allowed values include one of c("none", "hv", "h",
"v"). v: vertical, h:horizontal.}

\item{risk.table}{Allowed values include: \itemize{ \item TRUE or FALSE
specifying whether to show or not the risk table. Default is FALSE. \item
"absolute" or "percentage". Shows the \bold{absolute number} and the
\bold{percentage} of subjects at risk by time, respectively. \item "abs_pct"
to show both absolute number and percentage. \item "nrisk_cumcensor" and
"nrisk_cumevents". Show the number at risk and, the cumulative number of
censoring and events, respectively. }}

\item{cumevents}{logical value specifying whether to show or not the table of
the cumulative number of events. Default is FALSE.}

\item{cumcensor}{logical value specifying whether to show or not the table of
the cumulative number of censoring. Default is FALSE.}

\item{tables.height}{numeric value (in [0 - 1]) specifying the general height
of all tables under the main survival plot.}

\item{group.by}{a character vector containing the name of grouping variables. Should be of length <= 2.
Alias of the \code{\link{ggsurvplot_group_by}()} function.}

\item{facet.by}{a character vector containing the name of grouping variables
to facet the survival curves into multiple panels. Should be of length <= 2.
Alias of the \code{\link{ggsurvplot_facet}()} function.}

\item{add.all}{a logical value. If TRUE, add the survival curve of pooled patients (null model) onto the main plot.
Alias of the \code{\link{ggsurvplot_add_all}()} function.}

\item{combine}{a logical value. If TRUE, combine a list survfit objects on the same plot.
Alias of the \code{\link{ggsurvplot_combine}()} function.}

\item{ggtheme}{function, ggplot2 theme name. Default value is
\link{theme_survminer}. Allowed values include ggplot2 official themes: see
\code{\link[ggplot2]{theme}}.}

\item{tables.theme}{function, ggplot2 theme name. Default value is
\link{theme_survminer}. Allowed values include ggplot2 official themes: see
\code{\link[ggplot2]{theme}}. Note that, \code{tables.theme} is incremental to \code{ggtheme}.}

\item{...}{Futher arguments as described hereafter and
other arguments to be passed i) to ggplot2 geom_*() functions such
 as linetype, size, ii) or to the function \link[ggpubr]{ggpar}() for
 customizing the plots. See details section.}

\item{x}{an object of class ggsurvplot}

\item{surv.plot.height}{the height of the survival plot on the grid. Default
is 0.75. Ignored when risk.table = FALSE.}

\item{risk.table.height}{the height of the risk table on the grid. Increase
the value when you have many strata. Default is 0.25. Ignored when
risk.table = FALSE.}

\item{ncensor.plot.height}{The height of the censor plot. Used when
\code{ncensor.plot = TRUE}.}

\item{newpage}{open a new page. See \code{\link[gridExtra]{grid.arrange}}}
}
\value{
return an object of class ggsurvplot which is list containing the
 following components: \itemize{ \item plot: the survival plot (ggplot
 object) \item table: the number of subjects at risk table per time (ggplot
 object). \item cumevents: the cumulative number of events table (ggplot
 object). \item ncensor.plot: the number of censoring (ggplot object). \item
 data.survplot: the data used to plot the survival curves (data.frame). \item
 data.survtable: the data used to plot the tables under the main survival
 curves (data.frame). }
}
\description{
\code{ggsurvplot}() is a generic function to plot survival curves. Wrapper
 around the \code{ggsurvplot_xx()} family functions. Plot one or a list of
 survfit objects as generated by the
 \link[survival]{survfit.formula}() and \link{surv_fit} functions: \itemize{  \item
 \link{ggsurvplot_list}() \item \link{ggsurvplot_facet}() \item
 \link{ggsurvplot_group_by}() \item \link{ggsurvplot_add_all}() \item
 \link{ggsurvplot_combine}() } See the documentation for each function to
 learn how to control that aspect of the \link{ggsurvplot}().
 \code{ggsurvplot}() accepts further arguments to be passed to the
 \code{ggsurvplot_xx()} functions. Has options to: \itemize{ \item
 plot a list of survfit objects, \item facet survival curves into multiple
 panels, \item group  dataset by one or two grouping variables and to create
 the survival curves in each subset, \item combine multiple \code{survfit}
 objects into one plot, \item add survival curves of the pooled patients
 (null model) onto the main stratified plot, \item plot survival curves from
 a data frame containing survival curve summary as returned by
 \link{surv_summary}(). }
}
\details{
\itemize{  \item
 \strong{Color palettes}: The argument \strong{palette} can be used to
 specify the color to be used for each group. By default, the first color in
 the palette is used to color the first level of the factor variable. This
 default behavior can be changed by assigning correctly a named vector. That
 is, the names of colors should match the strata names as generated by the
 \code{ggsurvplot()} function in the legend.
 }
}
\section{FURTHER ARGUMENTS}{

Customize survival plots and tables. See also \link{ggsurvplot_arguments}.
}

\section{Plot title and axis labels}{

\itemize{
 \item \strong{title}: main title.
 \item \strong{xlab, ylab}: x and y axis labels, respectively.
}
}

\section{Legend title, labels and position}{

\itemize{
 \item \strong{legend}: character specifying legend position. Allowed values are one of
 c("top", "bottom", "left", "right", "none"). Default is "top" side position.
 to remove the legend use legend = "none". Legend position can be also
 specified using a numeric vector c(x, y). In this case it is
 possible to position the legend inside the plotting area. x and y are the
 coordinates of the legend box. Their values should be between 0 and 1.
 c(0,0) corresponds to the "bottom left" and c(1,1) corresponds to the "top
 right" position. For instance use legend = c(0.8, 0.2).
 \item \strong{legend.title}: legend title.
 \item \strong{legend.labs}: character vector specifying legend labels. Used to replace
 the names of the strata from the fit. Should be given in the same order as
 those strata.
}
}

\section{Axis limits, breaks and scales}{

\itemize{
\item \strong{break.time.by}: numeric value controlling time axis breaks. Default value
 is NULL.
 \item \strong{break.x.by}: alias of break.time.by. Numeric value controlling x axis
 breaks. Default value is NULL.
 \item \strong{break.y.by}: same as break.x.by but for y axis.
 \item \strong{surv.scale}: scale transformation of survival curves. Allowed values are
 "default" or "percent".
 \item \strong{xscale}: numeric or character value specifying x-axis scale. \itemize{
 \item If numeric, the value is used to divide the labels on the x axis. For
 example, a value of 365.25 will give labels in years instead of the original
 days. \item If character, allowed options include one of - "d_m", "d_y",
 "m_d", "m_y", "y_d" and "y_m" -  where \code{d = days}, \code{m = months} and \code{y = years}. For
 example, \code{xscale = "d_m"} will transform labels from days to months; \code{xscale =
 "m_y"}, will transform labels from months to years.}
 \item \strong{xlim,ylim}: x and y axis limits e.g. xlim = c(0, 1000), ylim = c(0, 1).
 \item \strong{axes.offset}: logical value. Default is TRUE. If FALSE, set the plot axes to start at the origin.
}
}

\section{Confidence interval}{

\itemize{
 \item \strong{conf.int.fill}: fill color to be used for confidence interval.
 \item \strong{conf.int.style}: confidence interval style. Allowed values include c("ribbon", "step").
 \item \strong{conf.int.alpha}: numeric value specifying confidence fill color transparency.
 Value should be in [0, 1], where 0 is full transparency and 1 is no transparency.
}
}

\section{P-value}{

\itemize{
 \item \strong{pval.size}: numeric value specifying the p-value text size. Default is 5.
 \item \strong{pval.coord}: numeric vector, of length 2,
 specifying the x and y coordinates of the p-value.
 Default values are NULL.
 \item \strong{pval.method.size}: the same as \code{pval.size} but for displaying
 \code{log.rank.weights} name.
 \item \strong{pval.method.coord}: the same as \code{pval.coord} but for displaying
 \code{log.rank.weights} name.
 \item \strong{log.rank.weights}: the name for the type of weights to be used in
 computing the p-value for log-rank test. By default \code{survdiff} is used
 to calculate regular log-rank test (with weights == 1). A user can specify
 \code{"1", "n", "sqrtN", "S1", "S2", "FH"} so that weights correspond to
 the test as: 1 - log-rank, n - Gehan-Breslow (generalized Wilcoxon),
 sqrtN - Tarone-Ware, S1 - Peto-Peto's modified survival estimate,
 S2 - modified Peto-Peto (by Andersen), FH - Fleming-Harrington(p=1, q=1).
}
}

\section{Median survival}{

\itemize{
 \item \strong{surv.median.line}: character vector for drawing a
 horizontal/vertical line at median survival.
 Allowed values include one of c("none", "hv", "h", "v"). v: vertical, h:horizontal.
}
}

\section{Censor points}{

\itemize{
 \item \strong{censor}: logical value. If TRUE (default), censors will be drawn.
 \item \strong{censor.shape}: character or numeric value specifying the point shape of censors.
 Default value is "+" (3), a sensible choice is "|" (124).
 \item \strong{censor.size}: numveric value specifying the point size of censors. Default is 4.5.
}
}

\section{Survival tables}{


\strong{General parameters for all tables}.
 The arguments below, when specified, will be applied to all survival tables at once
 (risk, cumulative events and cumulative censoring tables).
\itemize{
 \item \strong{tables.col}: color to be used for all tables under the main plot. Default
 value is "black". If you want to color by strata (i.e. groups), use
 tables.col = "strata".
 \item \strong{fontsize}: font size to be used for the risk table
 and the cumulative events table.
 \item \strong{font.family}: character vector specifying text element font family,
 e.g.: font.family = "Courier New".
 \item \strong{tables.y.text}: logical. Default is TRUE. If FALSE, the y axis tick
 labels of tables will be hidden.
 \item \strong{tables.y.text.col}: logical. Default value is FALSE. If TRUE, the y
 tick labels of tables will be colored by strata.
\item \strong{tables.height}: numeric value (in [0 - 1]) specifying the general height
 of all tables under the main survival plot.
 Increase the value when you have many strata. Default is 0.25.
}

\strong{Specific to the risk table}
\itemize{
 \item \strong{risk.table.title}: the title to be used for the risk table.
 \item \strong{risk.table.pos}: character vector specifying the risk table position.
 Allowed options are one of c("out", "in") indicating 'outside' or 'inside'
 the main plot, respectively. Default value is "out".
 \item \code{risk.table.col}, \code{risk.table.fontsize}, \code{risk.table.y.text},
 \code{risk.table.y.text.col} and \code{risk.table.height}: same as for the general parameters
 but applied to the risk table only.
}

\strong{Specific to the number of cumulative events table (cumevents)}
\itemize{
 \item \strong{cumevents.title}: the title to be used for the cumulative events table.
 \item \code{cumevents.col, cumevents.y.text, cumevents.y.text, cumevents.height}:
 same as for the general parameters but for the cumevents table only.
}

\strong{Specific to the number of cumulative censoring table (cumcensor)}
\itemize{
 \item \strong{cumcensor.title}: the title to be used for the cumcensor table.
 \item \code{cumcensor.col}, \code{cumcensor.y.text}, \code{cumcensor.y.text.col}, \code{cumcensor.height}:
  same as for the general parameters but for cumcensor table only.
}
}

\section{Survival plot height}{

\itemize{
 \item \strong{surv.plot.height}: the height of the survival plot on the grid. Default
 is 0.75. Ignored when risk.table = FALSE.
}
}

\section{Number of censored subjects barplot}{

\itemize{
 \item \strong{ncensor.plot}: logical value. If TRUE, the number of censored subjects at
 time t is plotted. Default is FALSE. Ignored when cumcensor = TRUE.
 \item \strong{ncensor.plot.title}: the title to be used for the censor plot. Used when
 \code{ncensor.plot = TRUE}.
 \item \strong{ncensor.plot.height}: the height of the censor plot. Used when
 \code{ncensor.plot = TRUE}.
}
}

\section{Other graphical parameters}{

The plot can be easily customized using additional arguments to be
 passed to the function \code{\link[ggpubr]{ggpar}()}.

 These arguments include
 \code{font.title, font.subtitle, font.caption, font.x, font.y, font.tickslab and font.legend},
 which are vectors of length 3 indicating respectively the size
 (e.g.: 14), the style (e.g.: "plain", "bold", "italic", "bold.italic") and
 the color (e.g.: "red") of main title, subtitle, caption, xlab and ylab,
 axis tick labels and legend, respectively. For example font.x = c(14,
 "bold", "red").

 Use font.x = 14, to change only font size; or use font.x =
 "bold", to change only font face.
}

\examples{

#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Example 1: Survival curves with two groups
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%

# Fit survival curves
#++++++++++++++++++++++++++++++++++++
require("survival")
fit<- survfit(Surv(time, status) ~ sex, data = lung)

# Basic survival curves
ggsurvplot(fit, data = lung)

# Customized survival curves
ggsurvplot(fit, data = lung,
 surv.median.line = "hv", # Add medians survival

 # Change legends: title & labels
 legend.title = "Sex",
 legend.labs = c("Male", "Female"),
 # Add p-value and tervals
 pval = TRUE,

 conf.int = TRUE,
 # Add risk table
 risk.table = TRUE,
 tables.height = 0.2,
 tables.theme = theme_cleantable(),

 # Color palettes. Use custom color: c("#E7B800", "#2E9FDF"),
 # or brewer color (e.g.: "Dark2"), or ggsci color (e.g.: "jco")
 palette = c("#E7B800", "#2E9FDF"),
 ggtheme = theme_bw() # Change ggplot2 theme
)

# Change font size, style and color
#++++++++++++++++++++++++++++++++++++
\dontrun{
# Change font size, style and color at the same time
ggsurvplot(fit, data = lung,  main = "Survival curve",
   font.main = c(16, "bold", "darkblue"),
   font.x = c(14, "bold.italic", "red"),
   font.y = c(14, "bold.italic", "darkred"),
   font.tickslab = c(12, "plain", "darkgreen"))
}



#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Example 2: Facet ggsurvplot() output by
# a combination of factors
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%

# Fit (complexe) survival curves
#++++++++++++++++++++++++++++++++++++
\dontrun{
require("survival")
fit3 <- survfit( Surv(time, status) ~ sex + rx + adhere,
                data = colon )

# Visualize
#++++++++++++++++++++++++++++++++++++
ggsurv <- ggsurvplot(fit3, data = colon,
  fun = "cumhaz", conf.int = TRUE,
  risk.table = TRUE, risk.table.col="strata",
  ggtheme = theme_bw())

# Faceting survival curves
curv_facet <- ggsurv$plot + facet_grid(rx ~ adhere)
curv_facet

# Faceting risk tables:
# Generate risk table for each facet plot item
ggsurv$table + facet_grid(rx ~ adhere, scales = "free")+
 theme(legend.position = "none")

 # Generate risk table for each facet columns
tbl_facet <- ggsurv$table + facet_grid(.~ adhere, scales = "free")
tbl_facet + theme(legend.position = "none")

# Arrange faceted survival curves and risk tables
g2 <- ggplotGrob(curv_facet)
g3 <- ggplotGrob(tbl_facet)
min_ncol <- min(ncol(g2), ncol(g3))
g <- gridExtra::gtable_rbind(g2[, 1:min_ncol], g3[, 1:min_ncol], size="last")
g$widths <- grid::unit.pmax(g2$widths, g3$widths)
grid::grid.newpage()
grid::grid.draw(g)

}

#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Example 3: CUSTOMIZED PVALUE
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Customized p-value
ggsurvplot(fit, data = lung, pval = TRUE)
ggsurvplot(fit, data = lung, pval = 0.03)
ggsurvplot(fit, data = lung, pval = "The hot p-value is: 0.031")

}
\author{
Alboukadel Kassambara, \email{alboukadel.kassambara@gmail.com}
}
