% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{basics_diagnostic_plot}
\alias{basics_diagnostic_plot}
\title{Diagnostic Plot of Basic Tree Measurements}
\usage{
basics_diagnostic_plot(las, height, cbh, crown_width, dbh, res = 0.1)
}
\arguments{
\item{las}{A `LAS` object (from the `lidR` package) containing the tree point cloud.}

\item{height}{Numeric. Total tree height.}

\item{cbh}{Numeric. Crown base height.}

\item{crown_width}{Numeric. Crown width.}

\item{dbh}{Numeric. Diameter at breast height.}

\item{res}{Numeric. Resolution for point cloud thinning; default is 0.1 m.}
}
\value{
A `ggplot` object displaying thinned tree points and markers for key measurements.
}
\description{
Generates a diagnostic 2D plot showing basic tree measurements such as tree height, crown base height (CBH),
crown width, and diameter at breast height (DBH) over a subsampled LAS point cloud.
}
\details{
The function first thins the point cloud using `lidR::decimate_points()` to improve plotting speed.
Then it overlays key measurement lines and markers for height, crown width, DBH, and crown base height.
}
\examples{
library(lidR)
path = system.file('extdata', 'tree_0744.laz', package='tReeTraits')
las = clean_las(readLAS(path))
ht = get_height(las)
dbh = get_dbh(las)
wid = get_width(las)[1]
cbh = get_crown_base(las)
basics_diagnostic_plot(las, height = ht, cbh = cbh,
                     crown_width = wid, dbh = dbh)
}
