% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{branch_distribution_plot}
\alias{branch_distribution_plot}
\title{Diagnostic Plot of Branch Diameter Distribution}
\usage{
branch_distribution_plot(qsm)
}
\arguments{
\item{qsm}{A QSM object (e.g., data frame returned by `run_treeqsm()`) containing cylinder information.}
}
\value{
A `ggplot` object displaying branch diameter (x-axis) versus total branch volume (y-axis).
}
\description{
Generates a diagnostic plot showing the distribution of branch diameters in a QSM.
This is a wrapper around `branch_size_distribution()` which computes branch metrics.
}
\details{
The function calls `branch_size_distribution()` with `plot = FALSE` to compute branch volumes
at midpoints of diameter bins, then generates a bar plot showing total volume per diameter bin.
}
\examples{
qsm_file = system.file('extdata',"tree_0744_qsm.txt", package='tReeTraits')
qsm = load_qsm(qsm_file)
branch_distribution_plot(qsm)
}
