% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{clean_las}
\alias{clean_las}
\title{Load, Recenter, and Remove low vegetation from `LAS` object representing
segmented tree}
\usage{
clean_las(las, bole_height = 1, quantile = 0.001)
}
\arguments{
\item{las}{`LAS` object from `lidR` package representing
individually segmented tree}

\item{bole_height}{numeric, height threshold below which all stem points
can be considered vegetation.}

\item{quantile}{See `normalize_las`. Z quantile at which grown level is specified since
ground points may not be identifiable with common algorithms if
ground points are removed during segmentation#'}
}
\value{
A cleaned `LAS` object with vegetation and noise removed,
normalized and recentered.
}
\description{
Function to normalize, remove noise, remove vegetation, and recenter `LAS`
representing segmented tree. Vegetation cleaning is accomplished by
identifying stem points (CrownScrochTLS::StemPoints) and removing all but the Stem
below the `z.threshold`.
}
\examples{
library(lidR)
las = readLAS(system.file("extdata", "tree_0744.laz", package="tReeTraits"))
las_cleaned = clean_las(las)
\donttest{
plot(las)
plot(las_cleaned)
}
}
