% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{recenter_las}
\alias{recenter_las}
\title{Recenter `LAS` object representing segmented tree based on the bole
location}
\usage{
recenter_las(las, height = 1)
}
\arguments{
\item{las}{`LAS` object from `lidR` package representing}

\item{height}{consider only points where Z < height, if specified.
Useful for considering only the tree bole, for centering.
individually segmented tree. Set `height = NULL` to recenter
using all points.}
}
\value{
A `LAS` object with X and Y coordinates recentered to (0, 0).
}
\description{
Function calculates the tree location using points below specified
`height` and recenters on `X=0 Y=0`
}
\examples{
library(lidR)
las = readLAS(system.file("extdata", "tree_0744.laz", package="tReeTraits"))
# view histogram of original X/Y values
par(mfrow=c(1,2))
hist(las$X)
hist(las$Y)
las = recenter_las(las)
# view histogram of X/Y values centered on 0,0
hist(las$X)

hist(las$Y)
}
