% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{taper_diagnostic_plot}
\alias{taper_diagnostic_plot}
\title{Diagnostic Plot of Tree Taper}
\usage{
taper_diagnostic_plot(qsm, dbh)
}
\arguments{
\item{qsm}{A QSM object (e.g., data frame returned by `run_treeqsm()`) containing cylinder information.}

\item{dbh}{Numeric. Diameter at breast height of the tree, used as input to the taper function.}
}
\value{
A `ggplot` object showing the fitted taper along the tree stem.
}
\description{
Generates a diagnostic plot showing the fitted taper of a tree using the Kozak model.
This is a simple wrapper around `fit_taper_Kozak()` to extract its plot output.
}
\details{
The function calls `fit_taper_Kozak()` with `plot = FALSE` and returns the plot component.
This allows quick visualization of the taper without modifying the underlying QSM.
}
\examples{
path = system.file('extdata', 'tree_0744_qsm.txt', package='tReeTraits')
qsm = load_qsm(path)
taper_diagnostic_plot(qsm, dbh = 0.25)
}
