% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unittest_methods.R
\name{check_pkg_tests_and_snaps}
\alias{check_pkg_tests_and_snaps}
\title{Check for Testing Infrastructure and Snapshot Files}
\usage{
check_pkg_tests_and_snaps(pkg_source_path)
}
\arguments{
\item{pkg_source_path}{Character. Path to the root of the package source.}
}
\value{
A list containing logical indicators and file counts describing the
test configuration of the package. The list includes:
\describe{
  \item{has_testthat}{Logical. Whether `tests/testthat/` exists.}
  \item{has_testit}{Logical. Whether `tests/testit/` exists.}
  \item{has_tests_base}{Logical. Whether base R test files exist in `tests/`.}
  \item{has_BioG_test}{Logical. Whether BioGenerics-style tests exist in `inst/tests/`.}
  \item{bioc_unit_tests_dir}{Character. Path to BioGenerics unit test directory (if any).}
  \item{bioc_run_ut_path}{Character. Path to BioGenerics `run_unitTests.R` (if any).}
  \item{has_snaps}{Logical. Whether `_snaps/` exists inside `tests/testthat/`.}
  \item{n_golden_tests}{Integer. Number of snapshot test files inside `_snaps/`.}
  \item{n_test_files}{Integer. Number of `test-*.R` files in `tests/testthat/`.}
}

This function always returns a value. It does **not** perform side effects
other than reading the package directory structure.
}
\description{
This function inspects an R package source tree and detects the presence
of common testing frameworks (`testthat`, `testit`, base R tests,
BioGenerics/Bioconductor-style tests) as well as snapshot files used
for golden testing.
}
\examples{
\donttest{
# Adjust CRAN repo (example only)
r <- getOption("repos")
r["CRAN"] <- "http://cran.us.r-project.org"
old <- options(repos = r)

# Example package contained in test.assessr
dp <- system.file(
  "test-data",
  "test.package.0001_0.1.0.tar.gz",
  package = "test.assessr"
)

# Set up package
install_list <- set_up_pkg(dp)
pkg_source_path <- install_list$pkg_source_path

# Install package locally (ensures correct test paths)
install_package_local(pkg_source_path)

# Detect tests and snapshots
test_pkg_data <- check_pkg_tests_and_snaps(pkg_source_path)

# Restore options
options(old)
}

}
