% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_tests_stf.R
\name{map_test}
\alias{map_test}
\title{Map the Structure of Expectations in a Testthat File}
\usage{
map_test(path)
}
\arguments{
\item{path}{Character. Path to a single test file (typically named
`test-*.R`).}
}
\value{
A `data.frame` in which each row corresponds to an expectation identified in
the test file. Typical columns include:
\describe{
  \item{description}{Context or test block label derived from the test file.}
  \item{expectation}{The expectation type (e.g., `expect_equal`).}
  \item{linerange}{Numeric vector giving the range of lines associated with
        the expectation.}
  \item{test}{Test label (combined description and nested block label, if
        applicable).}
}

This structured output is used internally by STF test‑mapping functions
(e.g., `map_tests_stf()`) for coverage analysis, skip mapping, and test
reporting.
}
\description{
This function parses a single testthat test file and extracts a structured
representation of the expectations it contains. It identifies top‑level test
blocks (e.g., `test_that()`, `describe()`, `tar_test()`) and any nested
expectation blocks (e.g., `it()`). The result maps expectation location,
context, and source line ranges for downstream analysis.
}
\details{
The function uses `utils::getParseData()` to inspect parse information from
the test file and constructs a hierarchical mapping of:
\itemize{
  \item test block context (e.g., `describe()`, `test_that()`)
  \item test labels or sub‑contexts (e.g., `it()` blocks)
  \item expectation type
  \item source line ranges associated with each expectation
}

If the file does not contain any parseable test blocks or expectations,
`NULL` is returned.
}
\seealso{
\code{\link[utils]{getParseData}}

Other stf_utility: 
\code{\link{create_coverage_skip_stf}()},
\code{\link{map_tests_stf}()},
\code{\link{nest_test}()},
\code{\link{run_covr_skip_stf}()}
}
\concept{stf_utility}
\keyword{internal}
