% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_tests_stf.R
\name{map_tests_stf}
\alias{map_tests_stf}
\title{Map the Structure of Testthat Tests (Standard Testing Framework)}
\usage{
map_tests_stf(path = "tests/testthat")
}
\arguments{
\item{path}{Character. Path to the test directory. Defaults to
`"tests/testthat"`.}
}
\value{
A consolidated `data.frame` where each row corresponds to an expectation
discovered within the STF test directory. The data frame typically contains:
\describe{
  \item{file}{Name of the test file in which the expectation appears.}
  \item{test}{The combined description and test label assigned to the
        expectation.}
  \item{expectation}{The expectation type detected (e.g., `expect_equal`).}
  \item{linerange}{The associated line numbers for that expectation.}
}

This structured mapping is used by downstream STF processing functions to
support skip mapping, coverage enhancement, and reporting.
}
\description{
This function analyses the test directory used by the Standard Testing
Framework (STF), typically `tests/testthat/`, and extracts a structured
representation of the unit tests contained in the directory. It identifies
test files, expectations, contexts, test names, and associated line ranges.
}
\details{
The function scans all testthat test files matching the pattern
`test*.R`. For each file, it extracts structured metadata describing the
hierarchy of expectations, including:
\itemize{
  \item file name
  \item context or description
  \item test label
  \item expectation type
  \item line ranges associated with each expectation
}

Files that contain no parseable test structure are omitted. If no valid
test files are found, the function returns `NULL`.
}
\seealso{
\code{\link[base]{list.files}},
  \code{\link[base]{lapply}},
  \code{\link[base]{rbind}}

Other stf_utility: 
\code{\link{create_coverage_skip_stf}()},
\code{\link{map_test}()},
\code{\link{nest_test}()},
\code{\link{run_covr_skip_stf}()}
}
\concept{stf_utility}
\keyword{internal}
