% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_tests_stf.R
\name{nest_expect}
\alias{nest_expect}
\title{Extract and Structure Expectations from Parsed Test Blocks}
\usage{
nest_expect(x)
}
\arguments{
\item{x}{A named list of parsed test blocks, typically produced by
\code{nest_test()}. Each element should contain parse data suitable for
expectation extraction via \code{get_expect()}.}
}
\value{
A \code{data.frame} in which each row corresponds to an expectation
extracted from the supplied test blocks. Typical columns include:
\describe{
  \item{expectation}{Name of the expectation function (e.g.,
        \code{"expect_equal"}).}
  \item{line1}{Starting line number of the expectation expression.}
  \item{line2}{Ending line number of the expectation expression.}
  \item{test}{Label identifying the test block the expectation belongs to.}
}
Returns \code{NULL} if no expectations are detected.
}
\description{
This internal helper takes a list of parsed test blocks (as produced by
\code{nest_test()}) and extracts expectation calls from each block using
\code{get_expect()}. It then assembles all detected expectations into a
structured data frame that associates each expectation with its
corresponding test label.
}
\details{
For each block in \code{x}, the function:
\itemize{
  \item calls \code{get_expect()} to extract expectation function calls
        and their line ranges,
  \item removes blocks with no expectations,
  \item attaches a \code{test} label using the block's list name, and
  \item binds all expectation results into a single consolidated data frame.
}

If no expectations are found in any block, the function returns \code{NULL}.
}
\keyword{internal}
