% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_tests_stf.R
\name{nest_test}
\alias{nest_test}
\title{Group Parsed Testthat Code into Logical Test Blocks (Internal)}
\usage{
nest_test(x, token_text = "^context$")
}
\arguments{
\item{x}{data.frame. Parse data produced by
\code{utils::getParseData(parse(file, keep.source = TRUE), includeText = TRUE)}.
Must include columns such as \code{token}, \code{text}, \code{parent},
and row names that correspond to node ids.}

\item{token_text}{Character. A regular expression used to select the
block‑starting function names (e.g., \code{"^context$"}, 
\code{"^test_that$|^describe$|^tar_test$"}, or \code{"^it$"}).
Defaults to \code{"^context$"}.}
}
\value{
A named list of data frames, where each element represents the parse rows
for a single detected test block. Names encode the block function and label.
If no matching blocks are found, an empty list is returned. This structure
is consumed by higher‑level STF mapping helpers (e.g., \code{map_test()},
\code{map_tests_stf()}) to derive expectations, contexts, and line ranges.
}
\description{
This internal helper groups parse data from a testthat test file into
logical test blocks based on calls to block‑defining functions such as
`context()`, `test_that()`, `describe()`, `it()`, or `tar_test()`. It
identifies top‑level expressions that match a given function‑name regex
and returns a named list of data frames—one per detected block—trimmed
to the relevant code region.
}
\details{
The function locates top‑level expressions whose function call tokens
(\code{SYMBOL_FUNCTION_CALL}) match \code{token_text}. For each matching
block, it:
\itemize{
  \item assigns a human‑readable name using the function name and its
        string constant argument (when available),
  \item trims the block to exclude leading parse noise, and
  \item returns the subset of \code{x} corresponding to that block.
}
Block names are prefixed with the function (e.g., \code{"test_that: ..."},
\code{"describe: ..."}, \code{"it: ..."}, \code{"tar_test: ..."}) when the
function is recognized.
}
\seealso{
\code{\link[utils]{getParseData}},
  \code{\link{map_test}},
  \code{\link{map_tests_stf}}

Other stf_utility: 
\code{\link{create_coverage_skip_stf}()},
\code{\link{map_test}()},
\code{\link{map_tests_stf}()},
\code{\link{run_covr_skip_stf}()}
}
\concept{stf_utility}
\keyword{internal}
