% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_up_pkg.R
\name{set_up_pkg}
\alias{set_up_pkg}
\title{Create Information on Local Package Installation}
\usage{
set_up_pkg(dp)
}
\arguments{
\item{dp}{Character string. Path to a package tarball or package directory.}
}
\value{
A named list with the following elements:
\itemize{
  \item \code{package_installed} — Logical. \code{TRUE} if the unpacked
        package directory exists, otherwise \code{FALSE}.
  \item \code{pkg_source_path} — Character string giving the unpacked
        package source directory, or \code{""} if unpacking failed.
}

The returned object is always a base R \code{list}. It contains no side
effects besides calling \code{unpack_tarball()} and checking filesystem paths.
}
\description{
This function unpacks a package tarball using \code{unpack_tarball()} and
returns information about whether the unpacked directory exists. It is a
lightweight preparatory step used before attempting a local package
installation.
}
\section{Output Meaning}{

A value of \code{package_installed = TRUE} indicates that the unpacked
directory exists on disk and can be used for local installation.  

\code{package_installed = FALSE} indicates either:
\itemize{
  \item \code{unpack_tarball()} returned an empty result, or
  \item the unpacked directory does not exist on disk.
}
}

\examples{
\dontrun{
set_up_pkg(path/to/package, "mypackage")
}
}
