% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk.R
\name{chk-text}
\alias{chk-text}
\alias{chk_ascii}
\alias{chk_text_miss}
\alias{chk_text_nmiss}
\title{Checks: text}
\usage{
chk_ascii(x)

chk_text_miss(x, miss = getOption("testdat.miss_text"))

chk_text_nmiss(x, miss = getOption("testdat.miss_text"))
}
\arguments{
\item{x}{A vector to check.}

\item{miss}{A vector of values to be treated as missing. The
\link[=testdat]{testdat.miss} or \link[=testdat]{testdat.miss_text} option is used by
default.}
}
\value{
A logical vector flagging records that have passed or failed the
check.
}
\description{
Check character vectors for non-ASCII characters or common NULL value
placeholders.
}
\examples{

chk_ascii(c("a", "\U1f642")) # detect non-ASCII characters

imported_data <- c(1, "#n/a", 2, "", 3, NA)
chk_text_miss(imported_data)
chk_text_nmiss(imported_data) # Equivalent to !chk_text_miss(imported_data)

}
\seealso{
\link[=chk-helper]{Checks: data frame helpers}

\link[=text-expectations]{Expectations: text}

Other vector checks: 
\code{\link{chk-dates}},
\code{\link{chk-dummy}},
\code{\link{chk-labels}},
\code{\link{chk-patterns}},
\code{\link{chk-uniqueness}},
\code{\link{chk-values}}
}
\concept{vector checks}
