% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatPlot.R
\name{StatPlot}
\alias{StatPlot}
\title{Statistic Plot}
\usage{
StatPlot(
  meta.data,
  stat.by,
  group.by = NULL,
  split.by = NULL,
  bg.by = NULL,
  flip = FALSE,
  NA_color = "grey",
  NA_stat = TRUE,
  keep_empty = FALSE,
  individual = FALSE,
  stat_level = NULL,
  plot_type = c("bar", "rose", "ring", "pie", "trend", "area", "dot", "sankey", "chord",
    "venn", "upset"),
  stat_type = c("percent", "count"),
  position = c("stack", "dodge"),
  palette = "Paired",
  palcolor = NULL,
  alpha = 1,
  bg_palette = "Paired",
  bg_palcolor = NULL,
  bg_alpha = 0.2,
  label = FALSE,
  label.size = 3.5,
  label.fg = "black",
  label.bg = "white",
  label.bg.r = 0.1,
  aspect.ratio = NULL,
  title = NULL,
  subtitle = NULL,
  xlab = NULL,
  ylab = NULL,
  legend.position = "right",
  legend.direction = "vertical",
  theme_use = "theme_this",
  theme_args = list(),
  combine = TRUE,
  nrow = NULL,
  ncol = NULL,
  byrow = TRUE,
  force = FALSE,
  seed = 11
)
}
\arguments{
\item{meta.data}{The data frame containing the data to be plotted.}

\item{stat.by}{The column name(s) in \code{meta.data} specifying the variable(s) to be plotted.}

\item{group.by}{The column name(s) in \code{meta.data} specifying the grouping variable(s).
Default is \code{NULL}.}

\item{split.by}{The column name in \code{meta.data} specifying the variable to split plots by.
Default is \code{NULL}.}

\item{bg.by}{The column name in \code{meta.data} specifying the background variable for bar plots.}

\item{flip}{Whether to flip the plot.
Default is \code{FALSE}.}

\item{NA_color}{The color to use for missing values.}

\item{NA_stat}{Whether to include missing values in the plot.
Default is \code{TRUE}.}

\item{keep_empty}{Whether to keep empty groups in the plot.
Default is \code{FALSE}.}

\item{individual}{Whether to plot individual groups separately.
Default is \code{FALSE}.}

\item{stat_level}{The level(s) of the variable(s) specified in \code{stat.by} to include in the plot.
Default is \code{NULL}.}

\item{plot_type}{The type of plot to create.
Can be one of \code{"bar"}, \code{"rose"}, \code{"ring"}, \code{"pie"}, \code{"trend"},
\code{"area"}, \code{"dot"}, \code{"sankey"}, \code{"chord"}, \code{"venn"}, or \code{"upset"}.}

\item{stat_type}{The type of statistic to compute for the plot.
Can be one of \code{"percent"} or \code{"count"}.}

\item{position}{The position adjustment for the plot.
Can be one of \code{"stack"} or \code{"dodge"}.}

\item{palette}{The name of the color palette to use.
Default is \code{"Paired"}.}

\item{palcolor}{Custom colors to use instead of palette.
Default is \code{NULL}.}

\item{alpha}{The transparency level for the plot.}

\item{bg_palette}{The name of the background color palette to use for bar plots.}

\item{bg_palcolor}{The color to use in the background color palette.}

\item{bg_alpha}{The transparency level for the background color in bar plots.}

\item{label}{Whether to add labels on the plot.
Default is \code{FALSE}.}

\item{label.size}{The size of the labels.}

\item{label.fg}{The foreground color of the labels.}

\item{label.bg}{The background color of the labels.}

\item{label.bg.r}{The radius of the rounded corners of the label background.}

\item{aspect.ratio}{Aspect ratio of the panel. Default is \code{NULL}.}

\item{title}{The title of the plot.
Default is \code{NULL}.}

\item{subtitle}{The subtitle of the plot.
Default is \code{NULL}.}

\item{xlab}{The label for the x-axis.
Default is \code{NULL}.}

\item{ylab}{The label for the y-axis.
Default is \code{NULL}.}

\item{legend.position}{The position of the legend.
Can be one of \code{"none"}, \code{"left"}, \code{"right"}, \code{"bottom"}, \code{"top"},
or a two-element numeric vector.
Default is \code{"right"}.}

\item{legend.direction}{The direction of the legend.
Can be one of \code{"vertical"} or \code{"horizontal"}.
Default is \code{"vertical"}.}

\item{theme_use}{The theme to use for the plot.
Default is \code{"theme_this"}.}

\item{theme_args}{Additional arguments to pass to the theme function.
Default is \code{list()}.}

\item{combine}{Whether to combine multiple plots into one.
Default is \code{TRUE}.}

\item{nrow}{Number of rows when combining plots.
Default is \code{NULL}.}

\item{ncol}{Number of columns when combining plots.
Default is \code{NULL}.}

\item{byrow}{Whether to fill plots by row when combining.
Default is \code{TRUE}.}

\item{force}{Whether to force plotting even when variables have more than 100 levels.
Default is \code{FALSE}.}

\item{seed}{Random seed for reproducibility.
Default is \code{11}.}
}
\description{
Visualizes data using various plot types such as bar plots,
rose plots, ring plots, pie charts, trend plots, area plots,
dot plots, sankey plots, chord plots, venn diagrams, and upset plots.
}
\examples{
set.seed(1)
meta_data <- data.frame(
  Type = factor(
    sample(c("A", "B", "C"),
      50,
      replace = TRUE,
      prob = c(0.5, 0.3, 0.2)
    )
  ),
  Group = factor(sample(c("X", "Y", "Z"), 50, replace = TRUE)),
  Batch = factor(sample(c("B1", "B2"), 50, replace = TRUE))
)
meta_data$Region <- factor(
  ifelse(meta_data$Group \%in\% c("X", "Y"), "R1", "R2"),
  levels = c("R1", "R2")
)

StatPlot(
  meta_data,
  stat.by = "Type",
  group.by = "Group",
  split.by = "Batch",
  plot_type = "bar",
  position = "dodge"
)

StatPlot(
  meta_data,
  stat.by = "Type",
  group.by = "Group",
  stat_type = "count",
  plot_type = "ring",
  position = "dodge"
)

StatPlot(
  meta_data,
  stat.by = "Type",
  group.by = "Group",
  stat_type = "count"
)

StatPlot(
  meta_data,
  stat.by = "Type",
  plot_type = "pie"
)

StatPlot(
  meta_data,
  stat.by = "Type",
  group.by = "Group",
  stat_type = "count",
  plot_type = "area"
)

StatPlot(
  meta_data,
  stat.by = "Type",
  group.by = "Group",
  plot_type = "dot"
)

StatPlot(
  meta_data,
  stat.by = "Type",
  group.by = "Group",
  stat_type = "count",
  plot_type = "trend"
)
}
