% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\encoding{UTF-8}
\name{bde_indicators}
\alias{bde_indicators}
\alias{bde_ind_gdp_var}
\alias{bde_ind_unemployment_rate}
\alias{bde_ind_euribor_12m_monthly}
\alias{bde_ind_euribor_12m_daily}
\alias{bde_ind_cpi_var}
\alias{bde_ind_ibex_monthly}
\alias{bde_ind_ibex_daily}
\alias{bde_ind_gdp_quarterly}
\alias{bde_ind_population}
\alias{bde_ind_ibex}
\title{Relevant Indicators of Spain}
\usage{
bde_ind_gdp_var(series_label = "GDP_YoY", ...)

bde_ind_unemployment_rate(series_label = "Unemployment_Rate", ...)

bde_ind_euribor_12m_monthly(series_label = "Euribor_12M_Monthly", ...)

bde_ind_euribor_12m_daily(series_label = "Euribor_12M_Daily", ...)

bde_ind_cpi_var(series_label = "Consumer_price_index_YoY", ...)

bde_ind_ibex_monthly(series_label = "IBEX_index_month", ...)

bde_ind_ibex_daily(series_label = "IBEX_index_day", ...)

bde_ind_gdp_quarterly(series_label = "GDP_quarterly_value", ...)

bde_ind_population(series_label = "Population_Spain", ...)
}
\arguments{
\item{series_label}{Optional. Character vector or value. Allows specifying a
custom label for the series extracted.}

\item{...}{
  Arguments passed on to \code{\link[=bde_series_load]{bde_series_load}}
  \describe{
    \item{\code{out_format}}{Whether the format should be returned as "long" or "wide".
Possible values are \code{"wide"} or \code{"long"}. See \strong{Value} for details and
section \strong{Examples}.}
    \item{\code{parse_numeric}}{Logical. If \code{TRUE} the columns would be parsed to
double (numeric) values. See \strong{Note}.}
    \item{\code{extract_metadata}}{Logical \code{TRUE/FALSE}. On \code{TRUE} the output is the
metadata of the requested series.}
    \item{\code{parse_dates}}{Logical. If \code{TRUE}, the dates will be parsed using
\code{\link[=bde_parse_dates]{bde_parse_dates()}}.}
    \item{\code{update_cache}}{Logical. If \code{TRUE}, the requested file will be updated
in the \code{cache_dir}.}
    \item{\code{cache_dir}}{A path to a cache directory. The directory can also be set
via options with \code{options(bde_cache_dir = "path/to/dir")}.}
    \item{\code{verbose}}{Logical \code{TRUE} or \code{FALSE}, display information useful for
debugging.}
  }}
}
\value{
A \link[tibble:tbl_df-class]{tibble} with the required series.
}
\description{
Set of helper functions for downloading some of the most relevant
macroeconomic indicators of Spain. Metadata available in \link{bde_ind_db}.
}
\details{
These functions are convenient wrappers around \code{\link[=bde_series_load]{bde_series_load()}} for
specific series. Use \verb{verbose = TRUE, extract_metadata = TRUE} to see the
specification and the source.
}
\examples{
\dontshow{if (bde_check_access()) withAutoprint(\{ # examplesIf}
\donttest{
bde_ind_gdp_var()
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=bde_series_load]{bde_series_load()}}, \code{\link[=bde_catalog_search]{bde_catalog_search()}}

Other indicators: 
\code{\link{bde_ind_db}}
}
\concept{indicators}
