% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amplisas2tidy.R
\name{amplisas2tidy}
\alias{amplisas2tidy}
\title{Read AmpliSAT results into tidy variants}
\usage{
amplisas2tidy(fp)
}
\arguments{
\item{fp}{Character vector with paths to 'txt' files from AmpliSAT results.
E.x. from 'allseqs', 'filtered', 'clustered'.}
}
\value{
Tidy variants (see 'variant_call()'').
}
\description{
Reads AmpliSAT results as tidy variants.
}
\details{
Converts text files in folder with AmpliSAS (Sebastian et al. 2016)
results into a tidy variants dataframe. MD5 is regenerated as the one in
AmpliSAT does not coincide with the MD5 associated with the DNA sequence.
}
\examples{
fp <- list.files(system.file("extdata", "amplisas", package = "tidyGenR"),
    full.names = TRUE
)
amplisas2tidy(fp)
}
\references{
Sebastian et al. (2016). \emph{AMPLISAS: a web server for multilocus genotyping
using next‐generation amplicon sequencing data}.
Molecular Ecology Resources, 16(2), 498-510.
}
