% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reads_loci_samples.R
\name{reads_loci_samples}
\alias{reads_loci_samples}
\title{Output reads per locus}
\usage{
reads_loci_samples(
  path,
  pattern_fq = "1.fastq.gz",
  sample_locus = "(^[a-zA-Z0-9]*).([a-zA-Z0-9]*)",
  all.variants = FALSE,
  var_id = "md5"
)
}
\arguments{
\item{path}{Folder with FASTQ files or tidy variants.}

\item{pattern_fq}{Pattern to select FASTQ files from the folder}

\item{sample_locus}{Sample and locus patterns to extract from file names.
Regex group 1 is assumed to be sample name and group 2 locus name.
By default, both groups are a alphanumeric string of any length separated by
any non-alphanumeric character.}

\item{all.variants}{(T/F) TRUE, one column per variant;
F, one column per locus. Only for tidy variants.}

\item{var_id}{'c('allele', 'md5', 'sequence')' column to use for naming
variant.}
}
\value{
Dataframe with columns being loci and rows being samples.
Samples are in first column.
}
\description{
Creates dataframe with reads distribution across samples (rows) and loci (columns).
}
\examples{
reads_loci_samples(
     path = system.file("extdata", "truncated",
                       package = "tidyGenR"),
     pattern_fq = "F_filt.fastq.gz")
# with variants dataframe
data("variants")
reads_loci_samples(path = variants)

}
