% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-annotation.R
\name{add_title}
\alias{add_title}
\alias{add_caption}
\title{Add plot title or caption}
\usage{
add_title(plot, title = ggplot2::waiver())

add_caption(plot, caption = ggplot2::waiver())
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{title}{Title of the plot.}

\item{caption}{Caption of the plot.}
}
\value{
A \code{tidyplot} object.
}
\description{
Add plot title or caption
}
\details{
\itemize{
\item \code{add_title()} and \code{add_caption()} support \href{https://www.rdocumentation.org/packages/grDevices/versions/3.6.2/topics/plotmath}{plotmath expressions} to include special characters.
See examples and \href{https://jbengler.github.io/tidyplots/articles/Advanced-plotting.html#special-characters}{Advanced plotting}.
}
}
\examples{
study |>
  tidyplot(x = treatment, y = score) |>
  add_data_points_beeswarm() |>
  add_title("This is my title")

study |>
  tidyplot(x = treatment, y = score) |>
  add_data_points_beeswarm() |>
  add_caption("This is the fine print in the caption")

# Plotmath expression
study |>
  tidyplot(x = treatment, y = score) |>
  add_data_points_beeswarm() |>
  add_title("$H[2]*O~and~E==m*c^{2}$")

}
