% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snp_allele_sharing.R
\name{snp_allele_sharing}
\alias{snp_allele_sharing}
\title{Compute the Pairwise Allele Sharing Matrix for a bigSNP object}
\usage{
snp_allele_sharing(
  X,
  ind.row = bigstatsr::rows_along(X),
  ind.col = bigstatsr::cols_along(X),
  block.size = bigstatsr::block_size(nrow(X))
)
}
\arguments{
\item{X}{a \link[bigstatsr:FBM.code256-class]{bigstatsr::FBM.code256} matrix (as found in the \code{genotypes}
slot of a \link[bigsnpr:bigSNP-class]{bigsnpr::bigSNP} object).}

\item{ind.row}{An optional vector of the row indices that are used. If not
specified, all rows are used. Don't use negative indices.}

\item{ind.col}{An optional vector of the column indices that are used. If not
specified, all columns are used. Don't use negative indices.}

\item{block.size}{maximum number of columns read at once. Note that, to
optimise the speed of matrix operations, we have to store in memory 3 times
the columns.}
}
\value{
a matrix of allele sharing between all pairs of individuals
}
\description{
This function computes the Allele Sharing matrix. Estimates Allele Sharing
(matching in \code{hierfstat})) between pairs of individuals (for each locus,
gives 1 if the two individuals are homozygous for the same allele, 0 if they
are homozygous for a different allele, and 1/2 if at least one individual is
heterozygous. Matching is the average of these 0, 1/2 and 1s)
}
\examples{
example_gt <- load_example_gt("gen_tbl")

X <- attr(example_gt$genotypes, "fbm")
snp_allele_sharing(X)

# Compute for individuals 1 to 5
snp_allele_sharing(X, ind.row = 1:5, ind.col = 1:5)

# Adjust block size
snp_allele_sharing(X, block.size = 2)

}
\seealso{
\code{\link[=pairwise_allele_sharing]{pairwise_allele_sharing()}} \code{\link[hierfstat:matching]{hierfstat::matching()}}
}
