% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_property.R
\name{tw_get_property}
\alias{tw_get_property}
\title{Get Wikidata property of one or more items as a tidy data frame}
\usage{
tw_get_property(
  id,
  p,
  language = tidywikidatar::tw_get_language(),
  id_df = NULL,
  cache = NULL,
  overwrite_cache = FALSE,
  cache_connection = NULL,
  disconnect_db = TRUE,
  wait = 0
)
}
\arguments{
\item{id}{A character vector, must start with Q, e.g. "Q180099" for the
anthropologist Margaret Mead. Can also be a data frame of one row,
typically generated with \code{\link[=tw_search]{tw_search()}} or a combination of \code{\link[=tw_search]{tw_search()}}
and \code{\link[=tw_filter_first]{tw_filter_first()}}.}

\item{p}{A character vector, a property. Must always start with the capital
letter "P", e.g. "P31" for "instance of".}

\item{language}{Defaults to language set with \code{\link[=tw_set_language]{tw_set_language()}}; if not
set, "en". Use "all_available" to keep all languages. For available
language values, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{the
dedicated Wikimedia page}.}

\item{id_df}{Default to \code{NULL}. If given, it should be a dataframe typically
generated with \code{\link[=tw_get]{tw_get()}}, and is used instead of calling Wikidata or
using SQLite cache. Ignored when \code{id} is of length more than one.}

\item{cache}{Defaults to \code{NULL}. If given, it should be given either \code{TRUE}
or \code{FALSE}. Typically set with \code{\link[=tw_enable_cache]{tw_enable_cache()}} or \code{\link[=tw_disable_cache]{tw_disable_cache()}}.}

\item{overwrite_cache}{Logical, defaults to \code{FALSE}. If \code{TRUE}, it overwrites
the table in the local sqlite database. Useful if the original Wikidata
object has been updated.}

\item{cache_connection}{Defaults to \code{NULL}. If \code{NULL}, and caching is
enabled, \code{tidywikidatar} will use a local sqlite database. A custom
connection to other databases can be given (see vignette \code{caching} for
details).}

\item{disconnect_db}{Defaults to \code{TRUE}. If \code{FALSE}, leaves the connection to
cache open.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to
Wikidata. If data are cached locally, wait time is not applied. If you are
running many queries systematically you may want to add some waiting time
between queries.}
}
\value{
A tibble, corresponding to the value for the given property. A tibble of zero rows if no relevant property found.
}
\description{
Get Wikidata property of one or more items as a tidy data frame
}
\examples{
# Who were the doctoral advisors - P184 - of Margaret Mead - Q180099?
advisors <- tw_get_property(id = "Q180099", p = "P184")
advisors

# tw_get_label(advisors)

# It is also possible to get one property for many id

if (interactive()) {
  tw_get_property(
    id = c(
      "Q180099",
      "Q228822"
    ),
    p = "P31"
  )

  # Or many properties for a single id

  tw_get_property(
    id = "Q180099",
    p = c("P21", "P31")
  )
}
}
