% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_extract.R
\name{tw_extract_single}
\alias{tw_extract_single}
\title{Extract item data from a list object retrieved from the Wikidata API}
\usage{
tw_extract_single(w, language = tidywikidatar::tw_get_language())
}
\arguments{
\item{w}{A list, typically retrieved with \code{\link[=tw_get_item]{tw_get_item()}}}

\item{language}{Defaults to language set with \code{\link[=tw_set_language]{tw_set_language()}}; if not
set, "en". Use "all_available" to keep all languages. For available
language values, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{the
dedicated Wikimedia page}.}
}
\value{
A data frame (a tibble) with four columns, such as the one created by
\code{\link[=tw_get]{tw_get()}}.
}
\description{
This function is mostly used internally and for testing.
}
\examples{
#' Retrieving from tests, but normally:
# w <- tw_get_item(id = "Q180099")

tidywikidatar:::tw_extract_single(w = list(tw_test_items[["Q180099"]]))
}
