% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lemmas.R
\docType{data}
\name{lemmas}
\alias{lemmas}
\title{Lemma Frequency Table}
\format{
A data frame with the variables:
\describe{
  \item{word}{Lemma (dictionary headword)}
  \item{n}{Count of this lemma in this text unit}
  \item{total}{Total lemma tokens in this text unit}
  \item{freq}{Frequency (n/total)}
  \item{id}{Text unit ID}
  \item{collection}{Collection code}
  \item{pitaka}{Pitaka name}
}
}
\usage{
lemmas
}
\description{
Lemma frequency table computed from the lemmatized text.
Tokenizes \code{\link{texts}$text_lemmatized} and counts word
frequencies per text unit on first access (~5 seconds).
}
\examples{
\donttest{
# First access triggers computation (~5 seconds)
head(lemmas)

# Most frequent lemmas across the entire canon
totals <- tapply(lemmas$n, lemmas$word, sum)
head(sort(totals, decreasing = TRUE), 20)
}

}
\keyword{datasets}
