% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reliability.R
\name{reliability}
\alias{reliability}
\alias{reliability.tna}
\title{Assess Model Reliability}
\usage{
reliability(x, ...)

\method{reliability}{tna}(
  x,
  types = "relative",
  split = 0.5,
  iter = 1000,
  scaling = "none",
  ...
)
}
\arguments{
\item{x}{A \code{tna} object.}

\item{...}{Ignored.}

\item{types}{A \code{character} vector giving the model types to fit.
See \code{\link[=build_model]{build_model()}} for available options.}

\item{split}{A \code{numeric} value between \code{0} and \code{1} specifying the proportion
of data for the split. The default is \code{0.5} for an even split.}

\item{iter}{An \code{integer} specifying number of iterations (splits). The
default is \code{1000}.}

\item{scaling}{See \code{\link[=compare]{compare()}}.}
}
\value{
A \code{tna_reliability} object.
}
\description{
Performs reliability analysis and outputs a concise summary of key
metrics. The results can also be visualized.
}
\examples{
# Small number of iterations for CRAN
model <- tna(engagement)
rel <- reliability(model, iter = 20)

}
\seealso{
Validation functions
\code{\link{bootstrap}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{permutation_test}()},
\code{\link{permutation_test.group_tna}()},
\code{\link{plot.group_tna_bootstrap}()},
\code{\link{plot.group_tna_permutation}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{plot.tna_bootstrap}()},
\code{\link{plot.tna_permutation}()},
\code{\link{plot.tna_reliability}()},
\code{\link{plot.tna_stability}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_permutation}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{print.summary.tna_bootstrap}()},
\code{\link{print.tna_bootstrap}()},
\code{\link{print.tna_clustering}()},
\code{\link{print.tna_permutation}()},
\code{\link{print.tna_reliability}()},
\code{\link{print.tna_stability}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna_bootstrap}()},
\code{\link{summary.tna_bootstrap}()}
}
\concept{validation}
