% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelcomp.R
\name{modelcomp}
\alias{modelcomp}
\title{Compare model fits and select best model}
\usage{
modelcomp(
  dataset,
  Conc,
  Response,
  model_list = NULL,
  metric = c("IC", "Res var", "Lack of fit"),
  list_obj = NULL,
  quiet = FALSE
)
}
\arguments{
\item{dataset}{A dataframe, containing the columns `Conc` and `Response`.}

\item{Conc}{Bare (unquoted) column name in `dataset` that groups the
`Response` variable.}

\item{Response}{Bare (unquoted) column name in `dataset` containing
the response variable.}

\item{model_list}{List. Model functions to be tested. Defaults to
include `"LL.4"`, `"LN.4"`, `"W1.4"`, `"W2.4"`. Most models from the drc
package are compatible; use `drc::getMeanFunctions()` for a more options.
See details for formatting}

\item{metric}{Character. Criterion used to select the best
model. Choices are `"IC"`, `"Res var"`, `"Lack of fit"`. Defaults
to "IC".}

\item{list_obj}{Optional. List object used for integration with
[runtoxdrc()].}

\item{quiet}{Logical. Indicates if results should be hidden. Defaults
to FALSE.}
}
\value{
A fitted drm model. If `list_obj` is provided, returns this within
the list as `list_obj$best_model`, along with the model name
 (`list_obj$best_model_name`), and the model compairison dataframe
 (`list_obj$model_df`). If model fitting fails, returns NULL.
}
\description{
Data is fitted to provided models, typically from the drc package. Models
 fitted successfully are compared using multiple goodness-of-fit scores,
 and organized using the score given as the `metric` argument.
 arguement.
}
\details{
The `model_list` argument requires a specific style. The argument must be a
 list; entries in the list are in the format where the shorthand is the name of
 the model function. An example of this is `"LL.4" = LL.4()`.
}
\examples{
toxresult2 <- toxresult[!toxresult$Conc \%in\% c ("Control", "Blank"),]
toxresult2$Conc <- as.numeric(toxresult2$Conc)
modelcomp(toxresult2, Conc, RFU, metric = "IC")

}
\seealso{
[drc::getMeanFunctions()] for compatabile models and their
 shorthand for `model_list`.
}
