% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspredbench.R
\docType{data}
\name{bioenergy}
\alias{bioenergy}
\title{FAOSTAT Bioenergy Database}
\format{
A list of time series.
}
\source{
\href{https://www.fao.org/faostat/en/#data/BE}{FAOSTAT Bioenergy Database}
}
\usage{
data(bioenergy)
}
\description{
Bioenergy data from FAOSTAT.
Data Type:	Bioenergy consumption and production. Category:	Environment. Creation Date	2024.
}
\details{
Series are named as \verb{<country>_<bio_consumption|bio_production>} and contain annual values.
}
\examples{
# Load bioenergy list and plot one series
data(bioenergy)
# bioenergy <- loadfulldata(bioenergy)
series <- bioenergy[[1]]
ts.plot(series, ylab = "TJ", xlab = "Year", main = "Bioenergy example")
}
\references{
FAO 2024. FAOSTAT Bioenergy, FAO, Rome, Italy.  ; United Nations Statistics Division (UNSD), 2011; International Recommendations for Energy Statistics (IRES).
}
\keyword{datasets}
