% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspredbench.R
\docType{data}
\name{emissions}
\alias{emissions}
\title{FAOSTAT Emissions Totals}
\format{
A list of time series.
}
\source{
\href{https://www.fao.org/faostat/en/#data/GT}{FAOSTAT Emissions Totals}.
}
\usage{
data(emissions)
}
\description{
National and global estimates of greenhouse gas (GHG) emissions.
Data Type:	Greenhouse gas emissions. Category:	Environment. Creation Date	2023.
}
\examples{
# Load emissions list and plot one series
data(emissions)
# emissions <- loadfulldata(emissions)
series <- emissions[[1]]
ts.plot(series, ylab = "kt CO2e", xlab = "Year", main = "Emissions example (CH4/N2O)")
}
\references{
FAO, 2023. FAOSTAT Climate Change: Agrifood systems emissions, Emissions Totals.
IPCC Guidelines and Reports: 1996, 2000, 2006, 2014, 2019.
PRIMAP-hist dataset v2.4.2: Gütschow et al., 2023.
}
\keyword{datasets}
