% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server_api.R
\name{tbs_publish_info}
\alias{tbs_publish_info}
\title{Publish info for a workbook or datasource on 'Tableau' Server/Cloud}
\usage{
tbs_publish_info(
  content_id,
  base_url = Sys.getenv("TABLEAU_BASE_URL"),
  site = Sys.getenv("TABLEAU_SITE"),
  token = Sys.getenv("TABLEAU_PAT")
)
}
\arguments{
\item{content_id}{Character. Workbook or datasource ID (GUID).}

\item{base_url}{Character. Server/Cloud base URL (e.g., "https://...").}

\item{site}{Character. Site contentUrl ("" for the default site).}

\item{token}{Character. REST credentials token (from a prior sign-in).}
}
\value{
A tibble with columns like \code{content_id}, \code{site}, \code{project}, \code{web_url},
\code{created_at}, \code{updated_at}. May be zero rows if unavailable.
}
\description{
Returns an empty tibble when credentials are missing or the item is not found.
}
\examples{
\dontshow{if (all(nzchar(Sys.getenv(c("TABLEAU_BASE_URL","TABLEAU_SITE","TABLEAU_PAT"))))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
tbs_publish_info("abc-123")
\dontshow{\}) # examplesIf}
}
