% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_trim}
\alias{umx_trim}
\title{Trim whitespace surrounding a string.}
\usage{
umx_trim(string, removeThis = NULL)
}
\arguments{
\item{string}{to trim}

\item{removeThis}{if not NULL then this regular expression is removed wherever found in 'string'}
}
\value{
\itemize{
\item string
}
}
\description{
Returns string without leading or trailing whitespace, like the php function.
See also built-in \code{\link[base:trimws]{base::trimws()}} does the same.
}
\examples{
umx_trim(" dog") # "dog"
trimws(" dog ", "l") # added by R in v 3.3.0
umx_trim("dog ") # "dog"
umx_trim("\t dog \n") # "dog"
umx_trim("xlsx dog.xlsx", "\\\\.?xlsx ?") # "dog"
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
\code{\link[base:trimws]{base::trimws()}}

Other String Functions: 
\code{\link{umx}},
\code{\link{umx_explode}()},
\code{\link{umx_explode_twin_names}()},
\code{\link{umx_grep}()},
\code{\link{umx_names}()},
\code{\link{umx_paste_names}()},
\code{\link{umx_rot}()},
\code{\link{umx_str_chars}()},
\code{\link{umx_str_from_object}()}
}
\concept{String Functions}
