% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.uniReg.R
\name{predict.cv.uniReg}
\alias{predict.cv.uniReg}
\title{make predictions from a "cv.uniReg" object.}
\usage{
\method{predict}{cv.uniReg}(object, newx, s = c("zero", "lambda.1se", "lambda.min"), ...)
}
\arguments{
\item{object}{Fitted \code{"cv.uniReg"}.}

\item{newx}{Matrix of new values for \code{x} at which predictions are to be
made. Must be a matrix; can be sparse as in \code{Matrix} package. See
documentation for \code{predict.glmnet}.}

\item{s}{Value(s) of the penalty parameter \code{lambda} at which
predictions are required. Default is the value \code{s="zero"} which corresponds to the smallest value of \code{lambda} used.  Alternatively  \code{s="lambda.1se"} or \code{s="lambda.min"} can be used. If
\code{s} is numeric, it is taken as the value(s) of \code{lambda} to be
used.}

\item{\dots}{Not used. Other arguments to predict.}
}
\value{
The object returned depends on the \dots{} argument which is passed
on to the \code{predict} method for \code{glmnet} objects.
}
\description{
This function makes predictions from a cross-validated \code{uniReg} model, using
the stored \code{"glmnet.fit"} object, and by default the smallest value of \code{lambda} used.
}
\details{
This function makes it easier to use the results of cross-validation to make
a prediction.
}
\examples{

x = matrix(rnorm(100 * 20), 100, 20)
y = rnorm(100)
cv.fit = cv.uniReg(x, y)
predict(cv.fit, newx = x[1:5, ])
coef(cv.fit)

}
\seealso{
\code{print}, and \code{coef} methods, and
\code{cv.uniReg}.
}
\author{
Trevor Hastie and Rob Tibshirani\cr Maintainer:
Trevor Hastie \href{mailto:hastie@stanford.edu}{hastie@stanford.edu}
}
\keyword{models}
\keyword{regression}
