% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ba_plot.R
\name{plot.ba_analysis}
\alias{plot.ba_analysis}
\alias{autoplot.ba_analysis}
\title{Plot method for ba_analysis objects}
\usage{
\method{plot}{ba_analysis}(
  x,
  show_ci = TRUE,
  show_points = TRUE,
  point_alpha = 0.6,
  point_size = 2,
  line_colors = NULL,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  ...
)

\method{autoplot}{ba_analysis}(
  object,
  show_ci = TRUE,
  show_points = TRUE,
  point_alpha = 0.6,
  point_size = 2,
  line_colors = NULL,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{ba_analysis}.}

\item{show_ci}{Logical; if \code{TRUE} (default), displays confidence interval
bands for bias and limits of agreement.}

\item{show_points}{Logical; if \code{TRUE} (default), displays individual
data points.}

\item{point_alpha}{Numeric; transparency of points (0-1, default: 0.6).}

\item{point_size}{Numeric; size of points (default: 2).}

\item{line_colors}{Named character vector with colors for \code{"bias"},
\code{"loa"}, and \code{"ci"}. Defaults to a clean color scheme.}

\item{title}{Character; plot title. If \code{NULL} (default), generates an
automatic title.}

\item{xlab}{Character; x-axis label. If \code{NULL}, uses "Mean of methods".}

\item{ylab}{Character; y-axis label. If \code{NULL}, auto-generates based on
difference type.}

\item{...}{Additional arguments (currently ignored).}

\item{object}{An object of class \code{ba_analysis}.}
}
\value{
A \code{ggplot} object that can be further customized.
}
\description{
Creates a Bland-Altman plot (difference vs. average) for visualizing
agreement between two measurement methods. The plot displays the bias
(mean difference) and limits of agreement with optional confidence intervals.
}
\details{
The Bland-Altman plot displays:
\itemize{
\item \strong{Points}: Each point represents a paired observation, plotted as
the difference (y - x) against the average ((x + y) / 2).
\item \strong{Bias line}: Solid horizontal line at the mean difference.
\item \strong{Limits of agreement}: Dashed horizontal lines at bias +/- 1.96 x SD.
\item \strong{Confidence intervals}: Shaded bands showing the uncertainty in
the bias and LoA estimates.
}

Patterns to look for:
\itemize{
\item \strong{Funnel shape}: Suggests proportional bias (variance increases
with magnitude).
\item \strong{Trend}: Suggests systematic relationship between difference and
magnitude.
\item \strong{Outliers}: Points outside the LoA may warrant investigation.
}
}
\examples{
# Basic Bland-Altman plot
set.seed(42)
method_a <- rnorm(50, mean = 100, sd = 15)
method_b <- method_a + rnorm(50, mean = 2, sd = 5)

ba <- ba_analysis(method_a, method_b)
plot(ba)

# Without confidence intervals
plot(ba, show_ci = FALSE)

# Customized appearance
plot(ba,
     point_alpha = 0.8,
     point_size = 3,
     title = "Method Comparison: A vs B")

# Further customization with ggplot2
library(ggplot2)
plot(ba) +
  theme_minimal() +
  scale_color_brewer(palette = "Set1")

# Using autoplot (ggplot2-style)
autoplot(ba)

}
\seealso{
\code{\link[=ba_analysis]{ba_analysis()}} for performing the analysis,
\code{\link[=summary.ba_analysis]{summary.ba_analysis()}} for detailed results
}
