% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmplotting_helpers.R
\name{add_risk_table}
\alias{add_risk_table}
\title{Add risk table annotation to KM plot}
\usage{
add_risk_table(
  risk.points,
  rpoints0,
  rpoints1,
  col.0,
  col.1,
  risk.cex,
  ymin,
  risk_offset,
  risk_delta,
  y.risk0,
  y.risk1
)
}
\arguments{
\item{risk.points}{Numeric vector of risk time points.}

\item{rpoints0}{Numeric vector of risk set counts for group 0.}

\item{rpoints1}{Numeric vector of risk set counts for group 1.}

\item{col.0}{Color for group 0.}

\item{col.1}{Color for group 1.}

\item{risk.cex}{Numeric; text size for risk table.}

\item{ymin}{Numeric; minimum y value.}

\item{risk_offset}{Numeric; offset for risk table.}

\item{risk_delta}{Numeric; delta for risk table.}

\item{y.risk0}{Numeric; y position for group 0 risk table.}

\item{y.risk1}{Numeric; y position for group 1 risk table.}
}
\value{
Invisibly returns NULL. Used for plotting side effects.
}
\description{
Adds risk set counts for two groups to a Kaplan-Meier plot.
}
