

#' @title Print Method for xRing Objects
#' @description Print method for objects of class "xRing".
#' @param x an object of class "xRing"
#' @param ...	additional parameters
#' @method print xRing
#' @return None.
#' @export
#' @examples
#'
#' data(PaPiRaw)
#' data(PaPiSpan)
#' PaPi <- detectRings(PaPiRaw, PaPiSpan)
#' class(PaPi)
#' print(PaPi$AFO1001a)
#' PaPi$AFO1001a
#' PaPi$AFO1001a[]
#' print(PaPi)
#' PaPi
#'

print.xRing <- function(x, ...) {
  cat(paste0(
    x$name, ": ", x$span[1], "-", x$span[2],
    " (Length: ", length(x$profile.raw), ")"
  ))
  invisible(x)
}


#' @title Print Method for xRingList Objects
#' @description Print method for objects of class "xRingList".
#' @inheritParams print.xRing
#' @return None.
#' @method print xRingList
#' @export
print.xRingList <- function(x, ...) {
  nn <- names(x)
  ll <- length(x)

  nSeries <- formatC(sapply(seq.int(ll), FUN = toString))
  if (length(nn) != ll) {
    for (i in seq_len(ll)) {
      nn[i] <- x[[i]]$name
    }
  }
  nn <- formatC(nn)

  for (i in seq_len(ll)) {
    span <- as.vector(x[[i]]$span)
    len <- formatC(length(x[[i]]$profile.raw), width = 4)
    cat(paste0(nSeries[i], ": ", nn[i], ": ", span[1], "-", span[2], " (Length: ", len, ")\n"))
  }
  invisible(x)
}
