% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cooling.R
\name{TrigonometricAdditiveCooling}
\alias{TrigonometricAdditiveCooling}
\title{Trigonometric additive cooling.}
\usage{
TrigonometricAdditiveCooling(k, lF)
}
\arguments{
\item{k}{Number of steps (time).}

\item{lF}{Local configuration.}
}
\value{
Temperature at time k.
}
\description{
This schedule decreases in proportion to the
             cosine of the temperature cycle in
             \code{lF$Generations()} (= number of generations) fractions 
             between the starting temperature \code{lF$Temp0()}
             and the final temperature \code{lF$TempN()}.
}
\details{
Temperature is updated at the end of each generation
         in the main loop of the genetic algorithm.
         \code{lF$Temp0()} is the starting temperature.
         \code{lF$TempN()} is the final temperature.
         \code{lF$Generations()} is the number of generations (time).
}
\examples{
parm<-function(x){function() {return(x)}}
lF<-list(Temp0=parm(100), TempN=parm(10), Generations=parm(50))
TrigonometricAdditiveCooling(0, lF)
TrigonometricAdditiveCooling(2, lF)
}
\references{
The-Crankshaft Publishing (2023)
         A Comparison of Cooling Schedules for Simulated Annealing.
 <https://what-when-how.com/artificial-intelligence/a-comparison-of-cooling-schedules-for-simulated-annealing-artificial-intelligence/>
}
\seealso{
Other Cooling: 
\code{\link{ExponentialAdditiveCooling}()},
\code{\link{ExponentialMultiplicativeCooling}()},
\code{\link{LogarithmicMultiplicativeCooling}()},
\code{\link{PowerAdditiveCooling}()},
\code{\link{PowerMultiplicativeCooling}()}
}
\concept{Cooling}
