% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling.R
\name{ContinuousScaleFitness}
\alias{ContinuousScaleFitness}
\title{Dispersion Ratio Based Continuous Fitness Scaling.}
\usage{
ContinuousScaleFitness(fit, lF)
}
\arguments{
\item{fit}{A fitness vector.}

\item{lF}{Local configuration.}
}
\value{
Scaled fitness vector.
}
\description{
The scaling exponent is the product of 
             \code{lF$RDMWeight()} and \code{lF$RDM()}.
}
\examples{
lF<-list()
lF$Offset<-parm(0.0001)
lF$RDMWeight<-parm(2)
lF$RDM<-parm(1.2)
fit<-sample(10, 20, replace=TRUE)
fit
ContinuousScaleFitness(fit, lF)
}
\seealso{
Other Scaling: 
\code{\link{DispersionRatio}()},
\code{\link{ScaleFitness}()},
\code{\link{ScalingFitness}()},
\code{\link{ThresholdScaleFitness}()}

Other Adaptive Parameter: 
\code{\link{ThresholdScaleFitness}()}
}
\concept{Adaptive Parameter}
\concept{Scaling}
