

/*
Refs:
- Xtensa Instruction Set Architecture (ISA) Summary for all Xtensa LX Processors
  https:
- Linux kernel's Xtensa atomic implementation
  https:
*/

use core::arch::asm;

pub(super) use core::sync::atomic;

pub(super) type State = u32;


#[inline(always)]
pub(super) fn disable() -> State {
    let ps: State;
    
    
    unsafe {
        
        
        
        asm!("rsil {0}, 15", out(reg) ps, options(nostack));
    }
    ps
}



/// # Safety


#[inline(always)]
pub(super) unsafe fn restore(ps: State) {
    
    
    unsafe {
        
        
        asm!(
            "wsr.ps {0}",
            "rsync",
            in(reg) ps,
            options(nostack),
        );
    }
}
