







//! Implementation of [Unicode Standard Annex #31][tr31] for determining which











//! ## Comparison of performance



































//! ## Comparison of data structures

//! #### unicode-xid





//! # const _: &str = stringify! {



//! # "

//! # "


//! # };































//! #### ucd-trie



//! [rust-lang/rust#33098].

//! [rust-lang/rust#33098]: https://github.com/rust-lang/rust/pull/33098







































//! #### fst















//! #### roaring























//! #### unicode-ident




















//! <td><img alt="XID_Start bitmap" width="256" src="https://user-images.githubusercontent.com/1940490/168647353-c6eeb922-afec-49b2-9ef5-c03e9d1e0760.png"></td>
//! <td><img alt="XID_Continue bitmap" width="256" src="https://user-images.githubusercontent.com/1940490/168647367-f447cca7-2362-4d7d-8cd7-d21c011d329b.png"></td>





























#![no_std]
#![doc(html_root_url = "https://docs.rs/unicode-ident/1.0.18")]
#![allow(clippy::doc_markdown, clippy::must_use_candidate)]

#[rustfmt::skip]
mod tables;

use crate::tables::{ASCII_CONTINUE, ASCII_START, CHUNK, LEAF, TRIE_CONTINUE, TRIE_START};


pub fn is_xid_start(ch: char) -> bool {
    if ch.is_ascii() {
        return ASCII_START.0[ch as usize];
    }
    let chunk = *TRIE_START.0.get(ch as usize / 8 / CHUNK).unwrap_or(&0);
    let offset = chunk as usize * CHUNK / 2 + ch as usize / 8 % CHUNK;
    unsafe { LEAF.0.get_unchecked(offset) }.wrapping_shr(ch as u32 % 8) & 1 != 0
}


pub fn is_xid_continue(ch: char) -> bool {
    if ch.is_ascii() {
        return ASCII_CONTINUE.0[ch as usize];
    }
    let chunk = *TRIE_CONTINUE.0.get(ch as usize / 8 / CHUNK).unwrap_or(&0);
    let offset = chunk as usize * CHUNK / 2 + ch as usize / 8 % CHUNK;
    unsafe { LEAF.0.get_unchecked(offset) }.wrapping_shr(ch as u32 % 8) & 1 != 0
}
