﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/sts/STSRequest.h>
#include <aws/sts/STS_EXPORTS.h>

namespace Aws {
namespace STS {
namespace Model {

/**
 */
class GetCallerIdentityRequest : public STSRequest {
 public:
  AWS_STS_API GetCallerIdentityRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetCallerIdentity"; }

  AWS_STS_API Aws::String SerializePayload() const override;

 protected:
  AWS_STS_API void DumpBodyToUrl(Aws::Http::URI& uri) const override;

 public:
};

}  // namespace Model
}  // namespace STS
}  // namespace Aws
