/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.views.IViewDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class NavigatorHandlerToggleView
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String viewId = event.getParameter("viewId");
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IViewPart view = UIUtils.findView((IWorkbenchWindow)workbenchWindow, (String)viewId);
        if (view != null && workbenchWindow.getActivePage().isPartVisible((IWorkbenchPart)view)) {
            workbenchWindow.getActivePage().hideView(view);
        } else {
            try {
                if (view != null) {
                    workbenchWindow.getActivePage().bringToTop((IWorkbenchPart)view);
                } else {
                    workbenchWindow.getActivePage().showView(viewId);
                }
            }
            catch (PartInitException e) {
                DBWorkbench.getPlatformUI().showError("Toggle view", "Cannot open view " + viewId, (Throwable)e);
            }
        }
        ActionUtils.fireCommandRefresh((String[])new String[]{"org.jkiss.dbeaver.core.view.toggle"});
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        String viewId = (String)parameters.get("viewId");
        IViewDescriptor viewDescriptor = PlatformUI.getWorkbench().getViewRegistry().find(viewId);
        if (viewDescriptor != null) {
            element.setText(viewDescriptor.getLabel());
            element.setIcon(viewDescriptor.getImageDescriptor());
            if (!CommonUtils.isEmpty((String)viewDescriptor.getDescription())) {
                element.setTooltip(viewDescriptor.getDescription());
            }
            IViewPart view = null;
            IViewReference viewReference = UIUtils.getActiveWorkbenchWindow().getActivePage().findViewReference(viewId);
            if (viewReference != null) {
                view = viewReference.getView(false);
            }
            element.setChecked(view != null);
        }
    }

    public static class ViewValues
    implements IParameterValues {
        public Map<String, String> getParameterValues() {
            HashMap<String, String> values = new HashMap<String, String>();
            IViewDescriptor[] iViewDescriptorArray = PlatformUI.getWorkbench().getViewRegistry().getViews();
            int n = iViewDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewDescriptor view = iViewDescriptorArray[n2];
                values.put(view.getLabel(), view.getId());
                ++n2;
            }
            return values;
        }
    }
}

