/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPObjectWithOrdinalPosition;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.dbeaver.model.struct.cache.DBSCompositeCache;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public abstract class JDBCCompositeCache<OWNER extends DBSObject, PARENT extends DBSObject, OBJECT extends DBSObject, ROW_REF extends DBSObject>
extends AbstractObjectCache<OWNER, OBJECT>
implements DBSCompositeCache<PARENT, OBJECT> {
    protected static final Log log = Log.getLog(JDBCCompositeCache.class);
    private static final String DEFAULT_OBJECT_NAME = "#DBOBJ";
    private final JDBCStructCache<OWNER, ?, ?> parentCache;
    private final Class<PARENT> parentType;
    private final Object parentColumnName;
    private final Object objectColumnName;
    private final Map<PARENT, List<OBJECT>> objectCache = new LinkedHashMap<PARENT, List<OBJECT>>();

    protected JDBCCompositeCache(JDBCStructCache<OWNER, ?, ?> parentCache, Class<PARENT> parentType, Object parentColumnName, Object objectColumnName) {
        this.parentCache = parentCache;
        this.parentType = parentType;
        this.parentColumnName = parentColumnName;
        this.objectColumnName = objectColumnName;
    }

    @NotNull
    protected abstract JDBCStatement prepareObjectsStatement(@NotNull JDBCSession var1, @NotNull OWNER var2, @Nullable PARENT var3) throws SQLException;

    @Nullable
    protected abstract OBJECT fetchObject(@NotNull JDBCSession var1, @NotNull OWNER var2, @NotNull PARENT var3, @NotNull String var4, @NotNull JDBCResultSet var5) throws SQLException, DBException;

    @Nullable
    protected abstract ROW_REF[] fetchObjectRow(@NotNull JDBCSession var1, @NotNull PARENT var2, @NotNull OBJECT var3, @NotNull JDBCResultSet var4) throws SQLException, DBException;

    protected PARENT getParent(@NotNull OBJECT object) {
        return (PARENT)object.getParentObject();
    }

    protected abstract void cacheChildren(@NotNull DBRProgressMonitor var1, @NotNull OBJECT var2, @NotNull List<ROW_REF> var3);

    protected void cacheChildren2(@NotNull DBRProgressMonitor monitor, @NotNull OBJECT object, @NotNull List<ROW_REF> children) {
    }

    protected boolean isEmptyObjectRowsAllowed() {
        return false;
    }

    @NotNull
    public List<OBJECT> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable OWNER owner) throws DBException {
        return this.getObjects(monitor, owner, null);
    }

    public List<OBJECT> getObjects(@NotNull DBRProgressMonitor monitor, OWNER owner, PARENT forParent) throws DBException {
        if (!monitor.isCanceled() && !monitor.isForceCacheUsage()) {
            this.loadObjects(monitor, owner, forParent);
        }
        return this.getCachedObjects(forParent);
    }

    public <TYPE extends OBJECT> List<TYPE> getTypedObjects(@NotNull DBRProgressMonitor monitor, OWNER owner, PARENT forParent, Class<TYPE> type) throws DBException {
        ArrayList<DBSObject> result = new ArrayList<DBSObject>();
        List<OBJECT> objects = this.getObjects(monitor, owner, forParent);
        if (objects != null) {
            for (DBSObject object : objects) {
                if (!type.isInstance(object)) continue;
                result.add((DBSObject)type.cast(object));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OBJECT> getCachedObjects(@Nullable PARENT forParent) {
        if (forParent == null) {
            Map<PARENT, List<OBJECT>> map = this.objectCache;
            synchronized (map) {
                if (!this.objectCache.isEmpty()) {
                    ArrayList<OBJECT> allChildren = new ArrayList<OBJECT>();
                    for (List<OBJECT> children : this.objectCache.values()) {
                        allChildren.addAll(children);
                    }
                    return allChildren;
                }
            }
            return this.getCachedObjects();
        }
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            return this.objectCache.get(forParent);
        }
    }

    public OBJECT getObject(@NotNull DBRProgressMonitor monitor, @NotNull OWNER owner, @NotNull String objectName) throws DBException {
        this.loadObjects(monitor, owner, null);
        return (OBJECT)this.getCachedObject(objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OBJECT getObject(@NotNull DBRProgressMonitor monitor, @NotNull OWNER owner, @Nullable PARENT forParent, @NotNull String objectName) throws DBException {
        this.loadObjects(monitor, owner, forParent);
        if (forParent == null) {
            return (OBJECT)this.getCachedObject(objectName);
        }
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            return (OBJECT)((DBSObject)DBUtils.findObject((Collection)this.objectCache.get(forParent), (String)objectName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheObject(@NotNull OBJECT object) {
        super.cacheObject(object);
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            PARENT parent = this.getParent(object);
            List objects = this.objectCache.computeIfAbsent(parent, k -> new ArrayList());
            objects.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(@NotNull OBJECT object, boolean resetFullCache) {
        super.removeObject(object, resetFullCache);
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            PARENT parent = this.getParent(object);
            if (resetFullCache) {
                this.objectCache.remove(parent);
            } else {
                List<OBJECT> subCache = this.objectCache.get(parent);
                if (subCache != null) {
                    subCache.remove(object);
                }
            }
        }
    }

    public void clearObjectCache(@NotNull PARENT forParent) {
        List<OBJECT> removedObjects = this.objectCache.remove(forParent);
        if (removedObjects != null) {
            for (DBSObject obj : removedObjects) {
                super.removeObject(obj, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            this.objectCache.clear();
        }
        super.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCache(@NotNull List<OBJECT> objects) {
        super.setCache(objects);
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            this.objectCache.clear();
            for (DBSObject object : objects) {
                PARENT parent = this.getParent(object);
                List parentObjects = this.objectCache.computeIfAbsent(parent, k -> new ArrayList());
                parentObjects.add(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadObjects(@NotNull DBRProgressMonitor monitor, @NotNull OWNER owner, @Nullable PARENT forParent) throws DBException {
        LinkedHashMap<DBSObject, Map> parentObjectMap;
        block66: {
            if (DBWorkbench.getPlatform().isUnitTestMode()) {
                log.debug((Object)"[TEST] Skip composite cache read in test mode");
                return;
            }
            Map<PARENT, List<OBJECT>> map = this.objectCache;
            synchronized (map) {
                if (monitor.isForceCacheUsage() || forParent == null && this.isFullyCached() || forParent != null && (!forParent.isPersisted() || this.objectCache.containsKey(forParent))) {
                    return;
                }
            }
            if (forParent == null) {
                this.parentCache.loadObjects(monitor, owner);
                this.parentCache.loadChildren(monitor, owner, null);
            }
            parentObjectMap = new LinkedHashMap<DBSObject, Map>();
            DBPDataSource dataSource = owner.getDataSource();
            assert (dataSource != null);
            monitor.beginTask("Load composite cache", 1);
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, owner, (String)"Load composite objects");
                 JDBCStatement dbStat = this.prepareObjectsStatement(session, owner, forParent);){
                dbStat.setFetchSize(1000);
                dbStat.executeStatement();
                JDBCResultSet dbResult = dbStat.getResultSet();
                if (dbResult == null) break block66;
                try {
                    while (dbResult.next()) {
                        DBSObject[] rowRef;
                        String objectName;
                        if (monitor.isCanceled()) {
                            return;
                        }
                        String string = forParent != null ? forParent.getName() : (this.parentColumnName instanceof Number ? JDBCUtils.safeGetString((ResultSet)dbResult, ((Number)this.parentColumnName).intValue()) : JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, this.parentColumnName.toString()));
                        String string2 = objectName = this.objectColumnName instanceof Number ? JDBCUtils.safeGetString((ResultSet)dbResult, ((Number)this.objectColumnName).intValue()) : JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, this.objectColumnName.toString());
                        if (CommonUtils.isEmpty((String)objectName)) {
                            objectName = this.getDefaultObjectName(dbResult, string);
                        }
                        if (forParent == null && CommonUtils.isEmpty((String)string)) {
                            log.debug((Object)("Empty parent name in " + String.valueOf((Object)this)));
                            continue;
                        }
                        Iterator<Object> parent = forParent;
                        if (parent == null && (parent = (DBSObject)this.parentCache.getObject(monitor, (DBSObject)owner, string, this.parentType)) == null) {
                            log.debug((Object)("Object '" + objectName + "' owner '" + string + "' not found"));
                            continue;
                        }
                        Map<PARENT, List<OBJECT>> map2 = this.objectCache;
                        synchronized (map2) {
                            if (this.objectCache.containsKey(parent)) {
                                continue;
                            }
                        }
                        Map objectMap = parentObjectMap.computeIfAbsent((DBSObject)parent, k -> new TreeMap());
                        ObjectInfo objectInfo = (ObjectInfo)objectMap.get(objectName);
                        if (objectInfo == null) {
                            OBJECT object = this.fetchObject(session, owner, parent, objectName, dbResult);
                            if (object == null || !this.isValidObject(monitor, (DBSObject)owner, (DBSObject)object)) continue;
                            objectName = object.getName();
                            objectInfo = new ObjectInfo(this, object);
                            objectMap.put(objectName, objectInfo);
                        }
                        if ((rowRef = this.fetchObjectRow(session, (DBSObject)parent, (DBSObject)objectInfo.object, dbResult)) == null || rowRef.length == 0) {
                            if (this.isEmptyObjectRowsAllowed()) continue;
                            objectInfo.broken = true;
                            continue;
                        }
                        for (DBSObject row : rowRef) {
                            if (row == null) continue;
                            objectInfo.rows.add(row);
                        }
                    }
                }
                finally {
                    dbResult.close();
                }
            }
            catch (SQLException ex) {
                if (JDBCUtils.isFeatureNotSupportedError(dataSource, ex)) {
                    log.debug((Object)("Error reading cache " + ((Object)((Object)this)).getClass().getSimpleName() + ", feature not supported: " + ex.getMessage()));
                    break block66;
                }
                throw new DBDatabaseException((Throwable)ex, dataSource);
            }
            finally {
                monitor.done();
            }
        }
        if (monitor.isCanceled()) {
            return;
        }
        JDBCCompositeCache jDBCCompositeCache = this;
        synchronized (jDBCCompositeCache) {
            Iterator iterator = this.objectCache;
            synchronized (iterator) {
                if (!(forParent == null && parentObjectMap.isEmpty() || forParent != null)) {
                    Iterator<OBJECT> globalCache = new ArrayList();
                    for (Map objMap : parentObjectMap.values()) {
                        if (objMap == null) continue;
                        for (ObjectInfo info : objMap.values()) {
                            if (info.broken) continue;
                            globalCache.add(info.object);
                        }
                    }
                    for (List<OBJECT> objects : this.objectCache.values()) {
                        globalCache.addAll(objects);
                    }
                    super.setCache(globalCache);
                    this.invalidateObjects(monitor, (DBSObject)owner, (Iterator)new AbstractObjectCache.CacheIterator((AbstractObjectCache)this));
                }
                for (Map.Entry entry : parentObjectMap.entrySet()) {
                    if (entry.getValue() == null || this.objectCache.containsKey(entry.getKey())) continue;
                    Collection objectInfos = ((Map)entry.getValue()).values();
                    ArrayList objects = new ArrayList(objectInfos.size());
                    for (ObjectInfo objectInfo : objectInfos) {
                        objectInfo.needsCaching = true;
                        objects.add(objectInfo.object);
                    }
                    this.objectCache.put((DBSObject)entry.getKey(), objects);
                }
                if (forParent == null) {
                    for (DBSObject dBSObject : this.parentCache.getTypedObjects(monitor, (DBSObject)owner, this.parentType)) {
                        if (parentObjectMap.containsKey(dBSObject) || this.objectCache.containsKey(dBSObject)) continue;
                        this.objectCache.put(dBSObject, new ArrayList());
                    }
                } else if (!parentObjectMap.containsKey(forParent) && !this.objectCache.containsKey(forParent)) {
                    this.objectCache.put(forParent, new ArrayList());
                }
            }
            for (Map.Entry colEntry : parentObjectMap.entrySet()) {
                for (ObjectInfo objectInfo : ((Map)colEntry.getValue()).values()) {
                    if (objectInfo.rows.size() > 1 && objectInfo.rows.getFirst() instanceof DBPObjectWithOrdinalPosition) {
                        objectInfo.rows.sort(DBUtils.orderComparator());
                    }
                    if (!objectInfo.needsCaching) continue;
                    this.cacheChildren(monitor, objectInfo.object, objectInfo.rows);
                }
            }
            for (Map.Entry colEntry : parentObjectMap.entrySet()) {
                for (ObjectInfo objectInfo : ((Map)colEntry.getValue()).values()) {
                    if (!objectInfo.needsCaching) continue;
                    this.cacheChildren2(monitor, objectInfo.object, objectInfo.rows);
                }
            }
        }
    }

    protected String getDefaultObjectName(JDBCResultSet dbResult, String parentName) {
        return parentName == null ? DEFAULT_OBJECT_NAME : parentName.toUpperCase() + "_#DBOBJ";
    }

    private class ObjectInfo {
        final OBJECT object;
        final List<ROW_REF> rows = new ArrayList();
        public boolean broken;
        public boolean needsCaching;

        /*
         * WARNING - Possible parameter corruption
         */
        public ObjectInfo(OBJECT object) {
            this.object = object;
        }
    }
}

