/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.generator.resultset;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDResultSetDataProvider;
import org.jkiss.dbeaver.model.data.DBDValueRow;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.generator.resultset.SQLGeneratorResultSet;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public class SQLGeneratorSelectManyFromData
extends SQLGeneratorResultSet {
    @Override
    public void generateSQL(@NotNull DBRProgressMonitor monitor, @NotNull StringBuilder sql, @NotNull DBDResultSetDataProvider dataProvider) throws DBException {
        boolean bl;
        sql.append("SELECT ");
        boolean hasAttr = false;
        for (DBSAttributeBase dBSAttributeBase : this.getAllAttributes(monitor, dataProvider)) {
            if (hasAttr) {
                sql.append(", ");
            }
            sql.append(DBUtils.getObjectFullName((DBPNamedObject)dBSAttributeBase, (DBPEvaluationContext)DBPEvaluationContext.DML));
            hasAttr = true;
        }
        sql.append(this.getLineSeparator()).append("FROM ").append(this.getEntityName(dataProvider.getSingleSource()));
        sql.append(this.getLineSeparator()).append("WHERE ");
        List<DBDAttributeBinding> keyAttributes = this.getKeyAttributes(monitor, dataProvider);
        boolean bl2 = bl = keyAttributes.size() > 1;
        if (bl) {
            sql.append("(");
        }
        hasAttr = false;
        for (DBDAttributeBinding binding : keyAttributes) {
            if (hasAttr) {
                sql.append(",");
            }
            sql.append(DBUtils.getObjectFullName((DBPNamedObject)binding.getAttribute(), (DBPEvaluationContext)DBPEvaluationContext.DML));
            hasAttr = true;
        }
        if (bl) {
            sql.append(")");
        }
        sql.append(" IN (");
        if (bl) {
            sql.append("\n");
        }
        List selectedRows = dataProvider.getSelectedRows();
        for (int i = 0; i < selectedRows.size(); ++i) {
            DBDValueRow firstRow = (DBDValueRow)selectedRows.get(i);
            if (bl) {
                sql.append("(");
            }
            hasAttr = false;
            for (DBDAttributeBinding binding : keyAttributes) {
                if (hasAttr) {
                    sql.append(",");
                }
                this.appendAttributeValue(dataProvider, sql, binding, firstRow, true);
                hasAttr = true;
            }
            if (bl) {
                sql.append(")");
            }
            if (i < selectedRows.size() - 1) {
                sql.append(",");
            }
            if (!bl) continue;
            sql.append("\n");
        }
        sql.append(");\n");
    }
}

