/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser;

import org.eclipse.jface.text.IDocument;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.text.parser.TPRuleBasedScanner;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class SQLParserContext {
    private static final Log log = Log.getLog(SQLParserContext.class);
    @Nullable
    private final DBPDataSourceContainer dataSourceContainer;
    @Nullable
    private final DBPDataSource dataSource;
    @NotNull
    private final SQLSyntaxManager syntaxManager;
    @NotNull
    private final SQLRuleManager ruleManager;
    @NotNull
    private final IDocument document;
    private TPRuleBasedScanner scanner;
    @Nullable
    private DBPPreferenceStore preferenceStore;
    @Nullable
    private SQLDialect cachedSqlDialect = null;

    public SQLParserContext(@Nullable DBPDataSource dataSource, @NotNull SQLSyntaxManager syntaxManager, @NotNull SQLRuleManager ruleManager, @NotNull IDocument document) {
        this.dataSource = dataSource;
        this.dataSourceContainer = dataSource != null ? dataSource.getContainer() : null;
        this.syntaxManager = syntaxManager;
        this.ruleManager = ruleManager;
        this.document = document;
    }

    public SQLParserContext(@Nullable DBPDataSourceContainer dataSourceContainer, @NotNull SQLSyntaxManager syntaxManager, @NotNull SQLRuleManager ruleManager, @NotNull IDocument document) {
        this.dataSourceContainer = dataSourceContainer;
        this.dataSource = dataSourceContainer != null ? dataSourceContainer.getDataSource() : null;
        this.syntaxManager = syntaxManager;
        this.ruleManager = ruleManager;
        this.document = document;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public SQLSyntaxManager getSyntaxManager() {
        return this.syntaxManager;
    }

    @NotNull
    public SQLRuleManager getRuleManager() {
        return this.ruleManager;
    }

    @NotNull
    public IDocument getDocument() {
        return this.document;
    }

    public SQLDialect getDialect() {
        if (this.dataSource != null) {
            return this.dataSource.getSQLDialect();
        }
        if (this.dataSourceContainer != null) {
            try {
                DBPDataSource dataSource = this.dataSourceContainer.getDataSource();
                if (dataSource != null) {
                    return dataSource.getSQLDialect();
                }
                if (this.cachedSqlDialect == null) {
                    this.cachedSqlDialect = this.dataSourceContainer.getScriptDialect().createInstance();
                }
                return this.cachedSqlDialect;
            }
            catch (Exception e) {
                log.warn((Object)String.format("Can't get dialect from dataSourceContainerId: %s", this.dataSourceContainer.getId()));
            }
        }
        return BasicSQLDialect.INSTANCE;
    }

    public TPRuleBasedScanner getScanner() {
        if (this.scanner == null) {
            this.scanner = new TPRuleBasedScanner();
            this.scanner.setRules(this.ruleManager.getAllRules());
        }
        return this.scanner;
    }

    public DBPPreferenceStore getPreferenceStore() {
        if (this.preferenceStore != null) {
            return this.preferenceStore;
        }
        DBPDataSource dataSource = this.getDataSource();
        return dataSource == null ? DBWorkbench.getPlatform().getPreferenceStore() : dataSource.getContainer().getPreferenceStore();
    }

    public void setPreferenceStore(@Nullable DBPPreferenceStore preferenceStore) {
        this.preferenceStore = preferenceStore;
    }

    void startScriptEvaluation() {
        this.getScanner().startEval();
    }

    void endScriptEvaluation() {
        this.getScanner().endEval();
    }
}

