/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Optional;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.freeplane.core.resources.components.JColorButton;
import org.freeplane.core.resources.components.PropertyBean;
import org.freeplane.core.ui.ColorTracker;
import org.freeplane.core.ui.components.JFreeplaneMenuItem;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.clipboard.ClipboardAccessor;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.IconFont;

public class ColorProperty
extends PropertyBean {
    private static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    Color color;
    private final Color defaultColor;
    JColorButton mButton;
    private final JButton transparentButton;

    public ColorProperty(String name, String defaultColor) {
        this(name, defaultColor, true);
    }

    public ColorProperty(String name, String defaultColor, boolean supportsTransparentColor) {
        super(name);
        this.defaultColor = ColorUtils.stringToColor(defaultColor);
        this.mButton = new JColorButton();
        this.mButton.addActionListener(this::chooseColor);
        this.color = null;
        if (supportsTransparentColor) {
            this.transparentButton = IconFont.createIconButton();
            this.transparentButton.setText("\ue902");
            this.transparentButton.setToolTipText(TextUtils.getText("ColorProperty.MakeTransparent"));
            this.transparentButton.addActionListener(e -> this.setTransparentColor());
        } else {
            this.transparentButton = null;
        }
    }

    private void chooseColor(ActionEvent arg0) {
        Color result = ColorTracker.showCommonJColorChooserDialog(this.mButton.getRootPane(), TextUtils.getOptionalText(this.getLabel()), this.getColorValue(), this.defaultColor);
        if (result != null) {
            this.setColorValue(result);
            this.firePropertyChangeEvent();
        }
    }

    public Color getColorValue() {
        return this.color;
    }

    @Override
    public String getValue() {
        Color colorValue = this.getColorValue();
        return colorValue == null ? null : ColorUtils.colorToRGBAString(colorValue);
    }

    @Override
    public JComponent getValueComponent() {
        return this.mButton;
    }

    @Override
    public void appendToForm(DefaultFormBuilder builder) {
        Box buttons = Box.createHorizontalBox();
        this.mButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        buttons.add(this.mButton);
        if (this.transparentButton != null) {
            buttons.add(this.transparentButton);
        }
        this.appendToForm(builder, buttons);
        this.mButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    this.showPopupMenu(evt);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    this.showPopupMenu(evt);
                }
            }

            private void showPopupMenu(MouseEvent evt) {
                JPopupMenu menu = new JPopupMenu();
                this.copyColorItem().ifPresent(menu::add);
                this.pasteColorItem().ifPresent(menu::add);
                this.resetColorItem().ifPresent(menu::add);
                menu.show(evt.getComponent(), evt.getX(), evt.getY());
            }

            private Optional<JMenuItem> resetColorItem() {
                if (ColorProperty.this.defaultColor == null || ColorProperty.this.defaultColor.equals(ColorProperty.this.color)) {
                    return Optional.empty();
                }
                JFreeplaneMenuItem item = new JFreeplaneMenuItem(TextUtils.getText("ColorProperty.ResetColor"));
                item.addActionListener(e -> {
                    ColorProperty.this.setColorValue(ColorProperty.this.defaultColor);
                    ColorProperty.this.firePropertyChangeEvent();
                });
                return Optional.of(item);
            }

            private Optional<JMenuItem> copyColorItem() {
                return Optional.ofNullable(ColorProperty.this.getValue()).map(this::copyColorItem);
            }

            private JMenuItem copyColorItem(String value) {
                JFreeplaneMenuItem item = new JFreeplaneMenuItem(TextUtils.getText("ColorProperty.CopyColor"));
                item.addActionListener(e -> ClipboardAccessor.getInstance().setClipboardContents(value));
                return item;
            }

            private Optional<JMenuItem> pasteColorItem() {
                try {
                    Transferable t = ClipboardAccessor.getInstance().getClipboardContents();
                    if (t == null || !t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        return Optional.empty();
                    }
                    String content = t.getTransferData(DataFlavor.stringFlavor).toString().trim();
                    Color color = ColorUtils.stringToColor(content);
                    JFreeplaneMenuItem item = new JFreeplaneMenuItem(TextUtils.getText("ColorProperty.PasteColor"));
                    item.addActionListener(e -> {
                        ColorProperty.this.setColorValue(color);
                        ColorProperty.this.firePropertyChangeEvent();
                    });
                    return Optional.of(item);
                }
                catch (UnsupportedFlavorException | IOException | NumberFormatException e2) {
                    return Optional.empty();
                }
            }
        });
    }

    private void setTransparentColor() {
        Color colorValue = this.getColorValue();
        if (colorValue == null) {
            this.setColorValue(TRANSPARENT_COLOR);
            this.firePropertyChangeEvent();
        } else if (colorValue.getAlpha() > 0) {
            int red = colorValue.getRed();
            int green = colorValue.getGreen();
            int blue = colorValue.getBlue();
            this.setColorValue(new Color(red, green, blue, 0));
            this.firePropertyChangeEvent();
        }
    }

    public void setColorValue(Color color) {
        this.color = color;
        this.mButton.setColor(color);
        this.updateTransparentButtonEnabledStatus();
    }

    private void updateTransparentButtonEnabledStatus() {
        if (this.transparentButton != null && this.mButton.isEnabled()) {
            this.transparentButton.setEnabled(this.color == null || this.color.getAlpha() > 0);
        }
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.mButton.setEnabled(pEnabled);
        this.updateTransparentButtonEnabledStatus();
        super.setEnabled(pEnabled);
    }

    @Override
    public void setValue(String value) {
        this.setColorValue(value == null ? null : ColorUtils.stringToColor(value));
    }
}

