/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.anim.dom.AbstractSVGAnimatedLength;
import io.sf.carte.echosvg.anim.dom.AnimatedLiveAttributeValue;
import io.sf.carte.echosvg.anim.dom.SVGOMCircleElement;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.SVGShapeElementBridge;
import io.sf.carte.echosvg.dom.svg.LiveAttributeException;
import io.sf.carte.echosvg.gvt.ShapeNode;
import io.sf.carte.echosvg.gvt.ShapePainter;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.w3c.dom.Element;

public class SVGCircleElementBridge
extends SVGShapeElementBridge {
    @Override
    public String getLocalName() {
        return "circle";
    }

    @Override
    public Bridge getInstance() {
        return new SVGCircleElementBridge();
    }

    @Override
    protected void buildShape(BridgeContext ctx, Element e, ShapeNode shapeNode) {
        SVGOMCircleElement ce = (SVGOMCircleElement)e;
        AbstractSVGAnimatedLength _cx = (AbstractSVGAnimatedLength)ce.getCx();
        float cx = this.safeAnimatedLength(_cx, 0.0f);
        AbstractSVGAnimatedLength _cy = (AbstractSVGAnimatedLength)ce.getCy();
        float cy = this.safeAnimatedLength(_cy, 0.0f);
        AbstractSVGAnimatedLength _r = (AbstractSVGAnimatedLength)ce.getR();
        float r = this.safeAnimatedLength(_r, 0.0f);
        float x = cx - r;
        float y = cy - r;
        float w = r * 2.0f;
        try {
            shapeNode.setShape((Shape)new Ellipse2D.Float(x, y, w, w));
        }
        catch (LiveAttributeException ex) {
            throw new BridgeException(ctx, ex);
        }
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue alav) {
        String ln;
        if (alav.getNamespaceURI() == null && ((ln = alav.getLocalName()).equals("cx") || ln.equals("cy") || ln.equals("r"))) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
            return;
        }
        super.handleAnimatedAttributeChanged(alav);
    }

    @Override
    protected ShapePainter createShapePainter(BridgeContext ctx, Element e, ShapeNode shapeNode) {
        Rectangle2D r2d = shapeNode.getShape().getBounds2D();
        if (r2d.getWidth() == 0.0 || r2d.getHeight() == 0.0) {
            return null;
        }
        return super.createShapePainter(ctx, e, shapeNode);
    }
}

