/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.art;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.art.ArtField;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ArtFieldGroup
implements StructConverter {
    private int fieldCount;
    private List<ArtField> fieldList = new ArrayList<ArtField>();

    public ArtFieldGroup(BinaryReader reader) throws IOException {
        this.fieldCount = reader.readNextInt();
        if (this.fieldCount > 65535) {
            throw new IOException("Too many ART fields: " + this.fieldCount);
        }
        for (int i = 0; i < this.fieldCount; ++i) {
            this.fieldList.add(new ArtField(reader));
        }
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public List<ArtField> getFieldList() {
        return this.fieldList;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType(ArtFieldGroup.class.getSimpleName() + "_" + this.fieldCount, 0);
        structure.setCategoryPath(new CategoryPath("/art"));
        structure.add(DWORD, "fieldCount", null);
        for (int i = 0; i < this.fieldCount; ++i) {
            structure.add(this.fieldList.get(i).toDataType(), "field_" + i, null);
        }
        return structure;
    }
}

