/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dtb;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class FdtNodeHeader
implements StructConverter {
    private int tag;
    private String name;
    private int nameLength = 0;

    public FdtNodeHeader(BinaryReader reader) throws IOException {
        this.tag = reader.readNextInt();
        this.name = reader.readAsciiString(reader.getPointerIndex());
        this.nameLength = (int)NumericUtilities.getUnsignedAlignedValue((long)(this.name.length() + 1), (long)4L);
        this.name = reader.readNextAsciiString(this.nameLength);
    }

    public int getTag() {
        return this.tag;
    }

    public String getName() {
        return this.name;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String structureName = "fdt_node_header_" + this.name.length();
        StructureDataType structure = new StructureDataType(structureName, 0);
        structure.add(DWORD, "tag", null);
        structure.add(STRING, this.nameLength, "name", null);
        return structure;
    }
}

