/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.omf.OmfLibraryRecord;
import ghidra.app.util.bin.format.omf.omf.OmfRecordFactory;
import ghidra.file.formats.omf.OmfArchiveFileSystem;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeByteProvider;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class OmfArchiveFileSystemFactory
implements GFileSystemFactoryByteProvider<OmfArchiveFileSystem>,
GFileSystemProbeByteProvider {
    public OmfArchiveFileSystem create(FSRLRoot targetFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        OmfArchiveFileSystem fs = new OmfArchiveFileSystem(targetFSRL, byteProvider);
        try {
            fs.mount(monitor);
        }
        catch (OmfException e) {
            throw new IOException(e);
        }
        return fs;
    }

    public boolean probe(ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        if (byteProvider.length() < 11L) {
            return false;
        }
        try {
            OmfRecordFactory factory = new OmfRecordFactory(byteProvider);
            return OmfLibraryRecord.checkMagicNumber((BinaryReader)factory.getReader());
        }
        catch (IOException e) {
            return false;
        }
    }
}

