/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.sparseimage;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ChunkHeader
implements StructConverter {
    private short chunk_type;
    private short reserved1;
    private int chunk_sz;
    private int total_sz;

    public ChunkHeader(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, true));
    }

    public ChunkHeader(BinaryReader reader) throws IOException {
        this.chunk_type = reader.readNextShort();
        this.reserved1 = reader.readNextShort();
        this.chunk_sz = reader.readNextInt();
        this.total_sz = reader.readNextInt();
    }

    public short getChunk_type() {
        return this.chunk_type;
    }

    public short getReserved1() {
        return this.reserved1;
    }

    public int getChunk_sz() {
        return this.chunk_sz;
    }

    public int getTotal_sz() {
        return this.total_sz;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("chunk_header", 0);
        structure.add(WORD, "chunk_type", null);
        structure.add(WORD, "reserved1", null);
        structure.add(DWORD, "chunk_sz", null);
        structure.add(DWORD, "total_sz", null);
        return structure;
    }
}

